/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.inventory;

import com.bokmcdok.butterflies.registries.ItemRegistry;
import com.bokmcdok.butterflies.world.block.ButterflyMicroscopeBlock;
import com.bokmcdok.butterflies.world.inventory.ButterflyBookResultSlot;
import com.bokmcdok.butterflies.world.inventory.ButterflyBookSlot;
import com.bokmcdok.butterflies.world.inventory.ButterflyScrollSlot;
import com.bokmcdok.butterflies.world.item.ButterflyBookItem;
import com.bokmcdok.butterflies.world.item.ButterflyScrollItem;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ButterflyMicroscopeMenu
extends AbstractContainerMenu {
    public static final int RESULT_SLOT = 0;
    private static final int CRAFT_SLOT_START = 1;
    private static final int CRAFT_SLOT_END = 3;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private final ItemRegistry itemRegistry;
    private final CraftingContainer craftSlots;
    private final ResultContainer resultSlots;
    private final ContainerLevelAccess containerLevelAccess;
    private final Player player;

    public ButterflyMicroscopeMenu(MenuType<?> menuType, int containerId, Inventory playerInventory) {
        this(null, menuType, containerId, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public ButterflyMicroscopeMenu(ItemRegistry itemRegistry, MenuType<?> menuType, int containerId, Inventory playerInventory, ContainerLevelAccess container) {
        super(menuType, containerId);
        int i;
        this.itemRegistry = itemRegistry;
        this.player = playerInventory.f_35978_;
        this.craftSlots = new TransientCraftingContainer((AbstractContainerMenu)this, 2, 1);
        this.resultSlots = new ResultContainer();
        this.containerLevelAccess = container;
        this.m_38897_(new ButterflyBookResultSlot(this.craftSlots, (Container)this.resultSlots, 0, 204, 17));
        this.m_38897_(new ButterflyBookSlot((Container)this.craftSlots, 0, 132, 17));
        this.m_38897_(new ButterflyScrollSlot((Container)this.craftSlots, 1, 150, 17));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 96 + j * 18, i * 18 + 47));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 96 + i * 18, 105));
        }
    }

    public int getButterflyScrollIndex() {
        Item item;
        ItemStack scroll = this.craftSlots.m_8020_(1);
        if (scroll != ItemStack.f_41583_ && (item = scroll.m_41720_()) instanceof ButterflyScrollItem) {
            ButterflyScrollItem scrollItem = (ButterflyScrollItem)item;
            return scrollItem.getButterflyIndex();
        }
        return -1;
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int slotIndex) {
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot.m_6657_()) {
            ItemStack slotItem = slot.m_7993_();
            result = slotItem.m_41777_();
            if (slotIndex == 0) {
                this.containerLevelAccess.m_39292_((level, blockPos) -> slotItem.m_41720_().m_7836_(slotItem, level, player));
                if (!this.m_38903_(slotItem, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotItem, result);
            } else if (slotIndex >= 3 && slotIndex < 39 ? !this.m_38903_(slotItem, 1, 3, false) && (slotIndex < 30 ? !this.m_38903_(slotItem, 30, 39, false) : !this.m_38903_(slotItem, 3, 30, false)) : !this.m_38903_(slotItem, 3, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (slotItem.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotItem.m_41613_() == result.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotItem);
            if (slotIndex == 0) {
                player.m_36176_(slotItem, false);
            }
        }
        return result;
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        this.containerLevelAccess.m_39292_((level, blockPos) -> this.m_150411_(player, (Container)this.craftSlots));
    }

    public void m_6199_(@NotNull Container container) {
        this.containerLevelAccess.m_39292_((level, blockPos) -> this.onCraftingGridSlotChanged(this, (Level)level, this.player, this.craftSlots, this.resultSlots));
    }

    public boolean m_6875_(@NotNull Player player) {
        return (Boolean)this.containerLevelAccess.m_39299_((level, blockPos) -> level.m_8055_(blockPos).m_60734_() instanceof ButterflyMicroscopeBlock && player.m_20275_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    private void onCraftingGridSlotChanged(AbstractContainerMenu menu, Level level, Player player, CraftingContainer craftingContainer, ResultContainer resultContainer) {
        if (!level.f_46443_) {
            Item item;
            ItemStack scroll;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack result = ItemStack.f_41583_;
            ItemStack book = craftingContainer.m_8020_(0);
            if (!book.m_41619_() && (scroll = craftingContainer.m_8020_(1)) != ItemStack.f_41583_ && (item = scroll.m_41720_()) instanceof ButterflyScrollItem) {
                ButterflyScrollItem scrollItem = (ButterflyScrollItem)item;
                result = book.m_150930_((Item)this.itemRegistry.getButterflyBook().get()) ? book.m_41777_() : new ItemStack((ItemLike)this.itemRegistry.getButterflyBook().get());
                if (!ButterflyBookItem.addPage(result, scrollItem.getButterflyIndex())) {
                    result = ItemStack.f_41583_;
                }
            }
            resultContainer.m_6836_(0, result);
            menu.m_150404_(0, result);
            serverPlayer.f_8906_.m_141995_((Packet)new ClientboundContainerSetSlotPacket(menu.f_38840_, menu.m_182425_(), 0, result));
        }
    }
}

