/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.item;

import com.bokmcdok.butterflies.client.gui.screens.ButterflyScrollScreen;
import com.bokmcdok.butterflies.registries.EntityTypeRegistry;
import com.bokmcdok.butterflies.registries.ItemRegistry;
import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import com.bokmcdok.butterflies.world.entity.decoration.ButterflyScroll;
import com.bokmcdok.butterflies.world.item.ButterflyContainerItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButterflyScrollItem
extends Item
implements ButterflyContainerItem {
    private final EntityTypeRegistry entityTypeRegistry;
    private final ItemRegistry itemRegistry;
    public static final String NAME = "item.butterflies.butterfly_scroll";
    private final int butterflyIndex;

    public static String getRegistryId(int butterflyIndex) {
        return "butterfly_scroll_" + ButterflySpeciesList.SPECIES[butterflyIndex];
    }

    public ButterflyScrollItem(EntityTypeRegistry entityTypeRegistry, ItemRegistry itemRegistry, int butterflyIndex) {
        super(new Item.Properties());
        this.entityTypeRegistry = entityTypeRegistry;
        this.itemRegistry = itemRegistry;
        this.butterflyIndex = butterflyIndex;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        this.appendButterflyNameToHoverText(stack, components);
        MutableComponent newComponent = Component.m_237115_((String)"tooltip.butterflies.scroll");
        Style style = newComponent.m_7383_().m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY)).m_131155_(Boolean.valueOf(true));
        newComponent.m_6270_(style);
        components.add((Component)newComponent);
        super.m_7373_(stack, level, components, tooltipFlag);
    }

    @Override
    public int getButterflyIndex() {
        return this.butterflyIndex;
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack itemStack) {
        return Component.m_237115_((String)NAME);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (level.m_5776_()) {
            CompoundTag tag = itemstack.m_41783_();
            if (tag != null && tag.m_128441_("CustomModelData")) {
                this.openScreen(tag.m_128451_("CustomModelData"));
            } else if (this.getButterflyIndex() >= 0) {
                this.openScreen(this.getButterflyIndex());
            } else {
                this.replaceWithPaper(player, hand, itemstack);
            }
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        Player player = context.m_43723_();
        if (player != null) {
            BlockPos clickedPos = context.m_8083_();
            Direction clickedFace = context.m_43719_();
            BlockPos blockPos = clickedPos.m_121945_(clickedFace);
            ItemStack itemInHand = context.m_43722_();
            if (!this.mayPlace(player, clickedFace, itemInHand, blockPos)) {
                return InteractionResult.FAIL;
            }
            Level level = context.m_43725_();
            int butterflyIndex = this.getButterflyIndex();
            CompoundTag tag = itemInHand.m_41783_();
            if (butterflyIndex < 0 && tag != null && tag.m_128441_("CustomModelData")) {
                butterflyIndex = tag.m_128451_("CustomModelData");
            }
            if (butterflyIndex >= 0) {
                ButterflyScroll butterflyScroll = new ButterflyScroll(this.entityTypeRegistry, this.itemRegistry, level, blockPos, clickedFace);
                butterflyScroll.setButterflyIndex(butterflyIndex);
                if (butterflyScroll.m_7088_()) {
                    if (!level.f_46443_) {
                        butterflyScroll.m_7084_();
                        level.m_220400_((Entity)player, GameEvent.f_157810_, butterflyScroll.m_20182_());
                        level.m_7967_((Entity)butterflyScroll);
                    }
                    itemInHand.m_41774_(1);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                return InteractionResult.CONSUME;
            }
            this.replaceWithPaper(player, context.m_43724_(), itemInHand);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6225_(context);
    }

    protected boolean mayPlace(Player player, Direction direction, ItemStack itemStack, BlockPos blockPos) {
        return !direction.m_122434_().m_122478_() && player.m_36204_(blockPos, direction, itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openScreen(int butterflyIndex) {
        Minecraft.m_91087_().m_91152_((Screen)new ButterflyScrollScreen(butterflyIndex));
    }

    private void replaceWithPaper(@NotNull Player player, @NotNull InteractionHand hand, ItemStack stack) {
        player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42516_, stack.m_41613_()));
        player.m_36356_(new ItemStack((ItemLike)Items.f_42749_, stack.m_41613_()));
    }
}

