/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.model;

import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ButterflyModel
extends HierarchicalModel<Butterfly> {
    private static final String ANTENNAE = "antennae";
    private static final String BODY = "body";
    private static final String LEFT_WING = "left_wing";
    private static final String RIGHT_WING = "right_wing";
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("butterflies", "butterfly"), "main");
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart left_wing;
    private final ModelPart right_wing;

    public ButterflyModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_(BODY);
        this.left_wing = this.body.m_171324_(LEFT_WING);
        this.right_wing = this.body.m_171324_(RIGHT_WING);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_(BODY, CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        body.m_171599_(BODY, CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-5.0f, -2.0f, -1.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        body.m_171599_(LEFT_WING, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-9.0f, -1.0f, 1.0f, 17.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f));
        body.m_171599_(RIGHT_WING, CubeListBuilder.m_171558_().m_171514_(0, 10).m_171488_(-9.0f, -1.0f, -11.0f, 17.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f));
        body.m_171599_(ANTENNAE, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -4.0f, -1.0f, 3.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-8.0f, -4.0f, 1.0f, 3.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(@NotNull Butterfly entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float WING_ARC = 0.25f;
        float WING_SPEED = 1.3f;
        float BODY_ANGLE = 0.7853982f;
        float BODY_ARC = 0.15f;
        float BODY_SPEED = 0.1f;
        if (entity.getIsLanded()) {
            this.body.f_104204_ = 0.7853982f;
            this.right_wing.f_104203_ = entity.getIsMoth() ? 0.15f : -1.495796f;
        } else {
            this.body.f_104204_ = 0.7853982f + Mth.m_14089_((float)(ageInTicks * 0.1f)) * 0.15f;
            this.right_wing.f_104203_ = Mth.m_14031_((float)(ageInTicks * 1.3f)) * (float)Math.PI * 0.25f;
        }
        this.left_wing.f_104203_ = -this.right_wing.f_104203_;
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.root;
    }
}

