/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.renderer.entity;

import com.bokmcdok.butterflies.config.ButterfliesConfig;
import com.bokmcdok.butterflies.world.entity.DebugInfoSupplier;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class EntityDebugInfoRenderer {
    public static <T extends Entity> void renderDebugInfo(T entity, PoseStack poseStack, MultiBufferSource multiBufferSource, Quaternionf cameraOrientation, Font font, int packedLightCoordinates) {
        if (!((Boolean)ButterfliesConfig.Server.debugInformation.get()).booleanValue()) {
            return;
        }
        String debugInfo = ((DebugInfoSupplier)entity).getDebugInfo();
        if (debugInfo.isBlank()) {
            return;
        }
        MutableComponent debugTextComponent = Component.m_237113_((String)debugInfo);
        float nameTagOffsetY = entity.m_278726_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, nameTagOffsetY, 0.0f);
        poseStack.m_252781_(cameraOrientation);
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f poseMatrix = poseStack.m_85850_().m_252922_();
        float backgroundOpacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int alpha = (int)(backgroundOpacity * 255.0f) << 24;
        float fontWidthCenter = -font.m_92852_((FormattedText)debugTextComponent) / 2;
        font.m_272077_((Component)debugTextComponent, fontWidthCenter, 0.0f, 0x20FFFFFF, false, poseMatrix, multiBufferSource, Font.DisplayMode.SEE_THROUGH, alpha, packedLightCoordinates);
        font.m_272077_((Component)debugTextComponent, fontWidthCenter, 0.0f, -1, false, poseMatrix, multiBufferSource, Font.DisplayMode.NORMAL, 0, packedLightCoordinates);
        poseStack.m_85849_();
    }
}

