/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.event.lifecycle;

import com.bokmcdok.butterflies.client.gui.screens.inventory.ButterflyFeederScreen;
import com.bokmcdok.butterflies.client.gui.screens.inventory.ButterflyMicroscopeScreen;
import com.bokmcdok.butterflies.registries.DecoratedPotPatternsRegistry;
import com.bokmcdok.butterflies.registries.ItemRegistry;
import com.bokmcdok.butterflies.registries.MenuTypeRegistry;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class LifecycleEventListener {
    private final DecoratedPotPatternsRegistry decoratedPotPatternsRegistry;
    private final ItemRegistry itemRegistry;
    private final MenuTypeRegistry menuTypeRegistry;

    public LifecycleEventListener(IEventBus modEventBus, DecoratedPotPatternsRegistry decoratedPotPatternsRegistry, ItemRegistry itemRegistry, MenuTypeRegistry menuTypeRegistry) {
        modEventBus.register((Object)this);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::commonSetup);
        this.decoratedPotPatternsRegistry = decoratedPotPatternsRegistry;
        this.itemRegistry = itemRegistry;
        this.menuTypeRegistry = menuTypeRegistry;
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        for (int i = 0; i < ButterflyInfo.TRAITS.length; ++i) {
            if (!Arrays.asList(ButterflyInfo.TRAITS[i]).contains((Object)ButterflyData.Trait.POISONOUS)) continue;
            BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43602_)}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)this.itemRegistry.getBottledButterflies().get(i).get()}), (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43584_));
        }
        HashMap itemToPotTextureMap = Maps.newHashMap((Map)DecoratedPotPatterns.f_271367_);
        itemToPotTextureMap.put((Item)this.itemRegistry.getButterflyPotterySherd().get(), this.decoratedPotPatternsRegistry.getButterflyPotPattern().getKey());
        DecoratedPotPatterns.f_271367_ = itemToPotTextureMap;
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)this.menuTypeRegistry.getButterflyFeederMenu().get()), ButterflyFeederScreen::new));
        event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)this.menuTypeRegistry.getButterflyMicroscopeMenu().get()), ButterflyMicroscopeScreen::new));
    }
}

