/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.event.network;

import com.bokmcdok.butterflies.network.protocol.common.custom.ClientBoundButterflyDataPacket;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.DataFormatException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;

public class NetworkEventListener {
    public static final EventNetworkChannel BUTTERFLY_NETWORK_CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)ClientBoundButterflyDataPacket.ID).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "FML3").eventNetworkChannel();

    public NetworkEventListener(IEventBus forgeEventBus) {
        forgeEventBus.register((Object)this);
        forgeEventBus.addListener(this::onDatapackSync);
        BUTTERFLY_NETWORK_CHANNEL.addListener(this::onButterflyCollectionPayload);
    }

    private void onDatapackSync(OnDatapackSyncEvent event) {
        Collection<ButterflyData> butterflyDataCollection = ButterflyData.getButterflyDataCollection();
        ClientBoundButterflyDataPacket packet = new ClientBoundButterflyDataPacket(butterflyDataCollection);
        ClientboundCustomPayloadPacket payload = new ClientboundCustomPayloadPacket(packet.getBuffer());
        if (event.getPlayer() != null) {
            event.getPlayer().f_8906_.m_9829_((Packet)payload);
        } else if (event.getPlayerList() != null) {
            for (ServerPlayer i : event.getPlayerList().m_11314_()) {
                i.f_8906_.m_9829_((Packet)payload);
            }
        }
    }

    private void onButterflyCollectionPayload(NetworkEvent.ServerCustomPayloadEvent event) {
        ButterflyData.reset();
        FriendlyByteBuf payload = event.getPayload();
        if (payload != null) {
            List butterflyData = (List)payload.m_236838_(ArrayList::new, buffer -> new ButterflyData(buffer.readInt(), buffer.m_130277_(), (ButterflyData.Size)buffer.m_130066_(ButterflyData.Size.class), (ButterflyData.Speed)buffer.m_130066_(ButterflyData.Speed.class), (ButterflyData.Rarity)buffer.m_130066_(ButterflyData.Rarity.class), buffer.m_236845_(x -> (ButterflyData.Habitat)x.m_130066_(ButterflyData.Habitat.class)), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.m_130281_(), (ButterflyData.ButterflyType)buffer.m_130066_(ButterflyData.ButterflyType.class), (ButterflyData.Diurnality)buffer.m_130066_(ButterflyData.Diurnality.class), (ButterflyData.ExtraLandingBlocks)buffer.m_130066_(ButterflyData.ExtraLandingBlocks.class), (ButterflyData.PlantEffect)buffer.m_130066_(ButterflyData.PlantEffect.class), (ButterflyData.EggMultiplier)buffer.m_130066_(ButterflyData.EggMultiplier.class), buffer.readBoolean(), buffer.readBoolean(), buffer.m_236845_(x -> (ButterflyData.Trait)x.m_130066_(ButterflyData.Trait.class)), buffer.m_130277_(), buffer.m_130277_(), buffer.m_130277_(), buffer.m_130277_()));
            for (ButterflyData butterfly : butterflyData) {
                try {
                    ButterflyData.addButterfly(butterfly);
                }
                catch (DataFormatException e) {
                    LogUtils.getLogger().error("Received invalid butterfly data.", (Throwable)e);
                }
            }
        }
    }
}

