/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.registries.BlockRegistry;
import com.bokmcdok.butterflies.registries.MenuTypeRegistry;
import com.bokmcdok.butterflies.world.block.entity.ButterflyFeederEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockEntityTypeRegistry {
    private MenuTypeRegistry menuTypeRegistry;
    private final DeferredRegister<BlockEntityType<?>> deferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"butterflies");
    private RegistryObject<BlockEntityType<ButterflyFeederEntity>> butterflyFeeder;

    public BlockEntityTypeRegistry(IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise(BlockRegistry blockRegistry, MenuTypeRegistry menuTypeRegistry) {
        this.menuTypeRegistry = menuTypeRegistry;
        this.butterflyFeeder = this.deferredRegister.register("butterfly_feeder", () -> BlockEntityType.Builder.m_155273_(this::createButterflyFeeder, (Block[])new Block[]{(Block)blockRegistry.getButterflyFeeder().get()}).m_58966_(null));
    }

    public RegistryObject<BlockEntityType<ButterflyFeederEntity>> getButterflyFeeder() {
        return this.butterflyFeeder;
    }

    private ButterflyFeederEntity createButterflyFeeder(BlockPos blockPos, BlockState blockState) {
        return new ButterflyFeederEntity(this.menuTypeRegistry, (BlockEntityType)this.butterflyFeeder.get(), blockPos, blockState);
    }
}

