/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.item;

import com.bokmcdok.butterflies.registries.ItemRegistry;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.item.ButterflyContainerItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButterflyNetItem
extends Item
implements ButterflyContainerItem {
    public static final String EMPTY_NAME = "butterfly_net";
    private static final String NAME = "item.butterflies.butterfly_net";
    private final ItemRegistry itemRegistry;
    private final int butterflyIndex;

    public static String getRegistryId(int butterflyIndex) {
        return "butterfly_net_" + ButterflyInfo.SPECIES[butterflyIndex];
    }

    public ButterflyNetItem(ItemRegistry itemRegistry, int butterflyIndex) {
        super(new Item.Properties().m_41487_(1));
        this.itemRegistry = itemRegistry;
        this.butterflyIndex = butterflyIndex;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        this.appendButterflyNameToHoverText(stack, components);
        String localisation = "tooltip.butterflies.release_butterfly";
        if (this.butterflyIndex < 0) {
            localisation = "tooltip.butterflies.butterfly_net";
        }
        MutableComponent newComponent = Component.m_237115_((String)localisation);
        Style style = newComponent.m_7383_().m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY)).m_131155_(Boolean.valueOf(true));
        newComponent.m_6270_(style);
        components.add((Component)newComponent);
        super.m_7373_(stack, level, components, tooltipFlag);
    }

    @Override
    public int getButterflyIndex() {
        return this.butterflyIndex;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return new ItemStack((ItemLike)this.itemRegistry.getEmptyButterflyNet().get());
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack itemStack) {
        return Component.m_237115_((String)NAME);
    }

    public boolean m_41470_() {
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        Butterfly butterfly;
        RegistryObject<Item> item;
        if (entity instanceof Butterfly && (item = this.itemRegistry.getButterflyNetFromIndex((butterfly = (Butterfly)entity).getButterflyIndex())) != null) {
            ItemStack newStack = new ItemStack((ItemLike)item.get(), 1);
            if (item != this.itemRegistry.getBurntButterflyNet()) {
                entity.m_146870_();
            }
            player.m_21008_(InteractionHand.MAIN_HAND, newStack);
            player.m_5496_(SoundEvents.f_12317_, 1.0f, 1.0f);
            return true;
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ResourceLocation entity = this.getButterflyEntity(stack);
        if (entity != null) {
            Vec3 lookAngle = player.m_20154_();
            BlockPos positionToSpawn = player.m_20183_().m_7918_((int)lookAngle.f_82479_, (int)lookAngle.f_82480_ + 1, (int)lookAngle.f_82481_);
            Butterfly.spawn(player.m_9236_(), entity, positionToSpawn, false);
            ItemStack newStack = new ItemStack((ItemLike)this.itemRegistry.getEmptyButterflyNet().get(), 1);
            player.m_21008_(hand, newStack);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }
}

