/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.item;

import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaterpillarItem
extends Item {
    private final ResourceLocation species;

    public static String getRegistryId(int butterflyIndex) {
        return "caterpillar_" + ButterflyInfo.SPECIES[butterflyIndex];
    }

    public CaterpillarItem(String species) {
        super(new Item.Properties());
        this.species = new ResourceLocation("butterflies", species);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        MutableComponent newComponent = Component.m_237115_((String)"tooltip.butterflies.place_caterpillar");
        Style style = newComponent.m_7383_().m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY)).m_131155_(Boolean.valueOf(true));
        newComponent.m_6270_(style);
        components.add((Component)newComponent);
        super.m_7373_(stack, level, components, tooltipFlag);
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack itemStack) {
        return Component.m_237115_((String)("entity." + this.species.toString().replace(":", ".")));
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        Player player = context.m_43723_();
        if (player != null) {
            BlockPos clickedPos = context.m_8083_();
            BlockState blockState = context.m_43725_().m_8055_(clickedPos);
            if (!ButterflyData.getEntry(this.species).isValidLandingBlock(blockState)) {
                return InteractionResult.FAIL;
            }
            if (!context.m_43725_().m_5776_()) {
                Direction clickedFace = context.m_43719_();
                Caterpillar.spawn((ServerLevel)context.m_43725_(), this.species, clickedPos.m_121945_(clickedFace), clickedFace.m_122424_(), false);
            } else {
                player.m_5496_(SoundEvents.f_12470_, 1.0f, 1.0f);
            }
            context.m_43722_().m_41774_(1);
            return InteractionResult.CONSUME;
        }
        return super.m_6225_(context);
    }
}

