/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.renderer.entity;

import com.bokmcdok.butterflies.client.model.ButterflyModel;
import com.bokmcdok.butterflies.client.renderer.entity.ButterflyBaseRenderer;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ButterflyRenderer
extends ButterflyBaseRenderer<Butterfly, ButterflyModel> {
    public ButterflyRenderer(EntityRendererProvider.Context context) {
        super(context, new ButterflyModel(context.bakeLayer(ButterflyModel.LAYER_LOCATION)), 0.2f);
    }

    public void render(@NotNull Butterfly entity, float p_115456_, float p_115457_, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLightCoordinates) {
        poseStack.pushPose();
        this.rotateIfLanded(entity, poseStack);
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        super.render((LivingEntity)entity, p_115456_, p_115457_, poseStack, multiBufferSource, packedLightCoordinates);
        poseStack.popPose();
        this.renderDebugInfo(entity, poseStack, multiBufferSource, packedLightCoordinates);
    }
}

