/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.event;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;

public class ForgeEventListener {
    public ForgeEventListener(IEventBus forgeEventBus) {
        forgeEventBus.register((Object)this);
    }

    @SubscribeEvent
    private void onTagsUpdated(TagsUpdatedEvent event) {
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD) {
            ForgeEventListener.addToPool(event.getRegistryAccess(), ResourceLocation.withDefaultNamespace((String)"village/plains/houses"), ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)"village/plains/houses/plains_butterfly_house_1"), 6);
            ForgeEventListener.addToPool(event.getRegistryAccess(), ResourceLocation.withDefaultNamespace((String)"village/savanna/houses"), ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)"village/savanna/houses/savanna_butterfly_house_1"), 4);
            ForgeEventListener.addToPool(event.getRegistryAccess(), ResourceLocation.withDefaultNamespace((String)"village/taiga/houses"), ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)"village/taiga/houses/taiga_butterfly_house_1"), 4);
        }
    }

    private static void addToPool(RegistryAccess registryAccess, ResourceLocation structurePool, ResourceLocation structureToAdd, int weight) {
        Registry registry = registryAccess.registryOrThrow(Registries.TEMPLATE_POOL);
        StructureTemplatePool pool = Objects.requireNonNull((StructureTemplatePool)registry.get(structurePool), structurePool.getPath());
        if (!(pool.rawTemplates instanceof ArrayList)) {
            pool.rawTemplates = new ArrayList(pool.rawTemplates);
        }
        SinglePoolElement addedElement = (SinglePoolElement)SinglePoolElement.single((String)structureToAdd.toString()).apply(StructureTemplatePool.Projection.RIGID);
        pool.rawTemplates.add(Pair.of((Object)addedElement, (Object)weight));
        for (int i = 0; i < weight; ++i) {
            pool.templates.add((Object)addedElement);
        }
    }
}

