/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.registries.BlockEntityTypeRegistry;
import com.bokmcdok.butterflies.registries.DataComponentRegistry;
import com.bokmcdok.butterflies.registries.ItemRegistry;
import com.bokmcdok.butterflies.registries.MenuTypeRegistry;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.block.BottledButterflyBlock;
import com.bokmcdok.butterflies.world.block.BottledCaterpillarBlock;
import com.bokmcdok.butterflies.world.block.ButterflyFeederBlock;
import com.bokmcdok.butterflies.world.block.ButterflyMicroscopeBlock;
import com.bokmcdok.butterflies.world.block.ButterflyOrigamiBlock;
import com.bokmcdok.butterflies.world.block.FlowerCropBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class BlockRegistry {
    private static final String[] ORIGAMI_IDS = new String[]{"butterfly_origami_black", "butterfly_origami_blue", "butterfly_origami_brown", "butterfly_origami_cyan", "butterfly_origami_gray", "butterfly_origami_green", "butterfly_origami_light_blue", "butterfly_origami_light_gray", "butterfly_origami_lime", "butterfly_origami_magenta", "butterfly_origami_orange", "butterfly_origami_pink", "butterfly_origami_purple", "butterfly_origami_red", "butterfly_origami_white", "butterfly_origami_yellow"};
    private static final BlockBehaviour.Properties BOTTLED_BUTTERFLY_PROPERTIES = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).isRedstoneConductor(BlockRegistry::never).isSuffocating(BlockRegistry::never).isValidSpawn(BlockRegistry::never).isViewBlocking(BlockRegistry::never).noOcclusion().sound(SoundType.GLASS).strength(0.3f);
    private static final BlockBehaviour.Properties GLOWING_BOTTLED_BUTTERFLY_PROPERTIES = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).isRedstoneConductor(BlockRegistry::never).isSuffocating(BlockRegistry::never).isValidSpawn(BlockRegistry::never).isViewBlocking(BlockRegistry::never).noOcclusion().sound(SoundType.GLASS).strength(0.3f).lightLevel(blockstate -> 15);
    private final DeferredRegister<Block> deferredRegister = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"butterflies");
    private List<DeferredHolder<Block, Block>> bottledButterflyBlocks;
    private List<DeferredHolder<Block, Block>> bottledCaterpillarBlocks;
    private DeferredHolder<Block, Block> butterflyFeeder;
    private DeferredHolder<Block, Block> butterflyMicroscope;
    private DeferredHolder<Block, Block> alliumBud;
    private DeferredHolder<Block, Block> azureBluetBud;
    private DeferredHolder<Block, Block> blueOrchidBud;
    private DeferredHolder<Block, Block> cornflowerBud;
    private DeferredHolder<Block, Block> dandelionBud;
    private DeferredHolder<Block, Block> lilyOfTheValleyBud;
    private DeferredHolder<Block, Block> orangeTulipBud;
    private DeferredHolder<Block, Block> oxeyeDaisyBud;
    private DeferredHolder<Block, Block> pinkTulipBud;
    private DeferredHolder<Block, Block> poppyBud;
    private DeferredHolder<Block, Block> redTulipBud;
    private DeferredHolder<Block, Block> whiteTulipBud;
    private DeferredHolder<Block, Block> witherRoseBud;
    private List<DeferredHolder<Block, Block>> butterflyOrigami;

    public static boolean never(BlockState ignoredBlockState, BlockGetter ignoredBlockGetter, BlockPos ignoredBlockPos, EntityType<?> ignoredEntityType) {
        return false;
    }

    public static boolean never(BlockState ignoredBlockState, BlockGetter ignoredBlockGetter, BlockPos ignoredBlockPos) {
        return false;
    }

    public BlockRegistry(@NotNull IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise(@NotNull BlockEntityTypeRegistry blockEntityTypeRegistry, @NotNull DataComponentRegistry dataComponentRegistry, @NotNull ItemRegistry itemRegistry, @NotNull MenuTypeRegistry menuTypeRegistry) {
        DeferredHolder newBlock;
        int i;
        Objects.requireNonNull(blockEntityTypeRegistry);
        Objects.requireNonNull(dataComponentRegistry);
        Objects.requireNonNull(itemRegistry);
        Objects.requireNonNull(menuTypeRegistry);
        this.bottledButterflyBlocks = new ArrayList<DeferredHolder<Block, Block>>();
        for (i = 0; i < ButterflyInfo.SPECIES.length; ++i) {
            newBlock = this.registerBottledButterfly(i);
            this.bottledButterflyBlocks.add(newBlock);
        }
        this.bottledCaterpillarBlocks = new ArrayList<DeferredHolder<Block, Block>>();
        for (i = 0; i < ButterflyInfo.SPECIES.length; ++i) {
            newBlock = this.deferredRegister.register(this.getBottledCaterpillarRegistryId(i), BottledCaterpillarBlock::new);
            this.bottledCaterpillarBlocks.add((DeferredHolder<Block, Block>)newBlock);
        }
        this.alliumBud = this.deferredRegister.register("bud_allium", () -> new FlowerCropBlock(Blocks.ALLIUM));
        this.azureBluetBud = this.deferredRegister.register("bud_azure_bluet", () -> new FlowerCropBlock(Blocks.AZURE_BLUET));
        this.blueOrchidBud = this.deferredRegister.register("bud_blue_orchid", () -> new FlowerCropBlock(Blocks.BLUE_ORCHID));
        this.cornflowerBud = this.deferredRegister.register("bud_cornflower", () -> new FlowerCropBlock(Blocks.CORNFLOWER));
        this.dandelionBud = this.deferredRegister.register("bud_dandelion", () -> new FlowerCropBlock(Blocks.DANDELION));
        this.lilyOfTheValleyBud = this.deferredRegister.register("bud_lily_of_the_valley", () -> new FlowerCropBlock(Blocks.LILY_OF_THE_VALLEY));
        this.orangeTulipBud = this.deferredRegister.register("bud_orange_tulip", () -> new FlowerCropBlock(Blocks.ORANGE_TULIP));
        this.oxeyeDaisyBud = this.deferredRegister.register("bud_oxeye_daisy", () -> new FlowerCropBlock(Blocks.OXEYE_DAISY));
        this.pinkTulipBud = this.deferredRegister.register("bud_pink_tulip", () -> new FlowerCropBlock(Blocks.PINK_TULIP));
        this.poppyBud = this.deferredRegister.register("bud_poppy", () -> new FlowerCropBlock(Blocks.POPPY));
        this.redTulipBud = this.deferredRegister.register("bud_red_tulip", () -> new FlowerCropBlock(Blocks.RED_TULIP));
        this.whiteTulipBud = this.deferredRegister.register("bud_white_tulip", () -> new FlowerCropBlock(Blocks.WHITE_TULIP));
        this.witherRoseBud = this.deferredRegister.register("bud_wither_rose", () -> new FlowerCropBlock(Blocks.WITHER_ROSE));
        this.butterflyFeeder = this.deferredRegister.register("butterfly_feeder", () -> new ButterflyFeederBlock(blockEntityTypeRegistry, menuTypeRegistry));
        this.butterflyMicroscope = this.deferredRegister.register("butterfly_microscope", () -> new ButterflyMicroscopeBlock(dataComponentRegistry, itemRegistry, menuTypeRegistry));
        this.butterflyOrigami = new ArrayList<DeferredHolder<Block, Block>>();
        for (String id : ORIGAMI_IDS) {
            this.butterflyOrigami.add(this.registerButterflyOrigami(id));
        }
    }

    public DeferredHolder<Block, Block> getAlliumBud() {
        return this.alliumBud;
    }

    public DeferredHolder<Block, Block> getAzureBluetBud() {
        return this.azureBluetBud;
    }

    public DeferredHolder<Block, Block> getBlueOrchidBud() {
        return this.blueOrchidBud;
    }

    public List<DeferredHolder<Block, Block>> getBottledButterflyBlocks() {
        return this.bottledButterflyBlocks;
    }

    public List<DeferredHolder<Block, Block>> getBottledCaterpillarBlocks() {
        return this.bottledCaterpillarBlocks;
    }

    public DeferredHolder<Block, Block> getButterflyFeeder() {
        return this.butterflyFeeder;
    }

    public DeferredHolder<Block, Block> getButterflyMicroscope() {
        return this.butterflyMicroscope;
    }

    public List<DeferredHolder<Block, Block>> getButterflyOrigami() {
        return this.butterflyOrigami;
    }

    public DeferredHolder<Block, Block> getCornflowerBud() {
        return this.cornflowerBud;
    }

    public DeferredHolder<Block, Block> getDandelionBud() {
        return this.dandelionBud;
    }

    public DeferredHolder<Block, Block> getLilyOfTheValleyBud() {
        return this.lilyOfTheValleyBud;
    }

    public DeferredHolder<Block, Block> getOrangeTulipBud() {
        return this.orangeTulipBud;
    }

    public DeferredHolder<Block, Block> getOxeyeDaisyBud() {
        return this.oxeyeDaisyBud;
    }

    public DeferredHolder<Block, Block> getPinkTulipBud() {
        return this.pinkTulipBud;
    }

    public DeferredHolder<Block, Block> getPoppyBud() {
        return this.poppyBud;
    }

    public DeferredHolder<Block, Block> getRedTulipBud() {
        return this.redTulipBud;
    }

    public DeferredHolder<Block, Block> getWhiteTulipBud() {
        return this.whiteTulipBud;
    }

    public DeferredHolder<Block, Block> getWitherRoseBud() {
        return this.witherRoseBud;
    }

    private String getBottledButterflyRegistryId(int butterflyIndex) {
        return "bottled_butterfly_" + ButterflyInfo.SPECIES[butterflyIndex];
    }

    private String getBottledCaterpillarRegistryId(int butterflyIndex) {
        return "bottled_caterpillar_" + ButterflyInfo.SPECIES[butterflyIndex];
    }

    private DeferredHolder<Block, Block> registerBottledButterfly(int butterflyIndex) {
        String registryId = this.getBottledButterflyRegistryId(butterflyIndex);
        if (Arrays.asList(ButterflyInfo.TRAITS[butterflyIndex]).contains((Object)ButterflyData.Trait.GLOW)) {
            return this.deferredRegister.register(registryId, () -> new BottledButterflyBlock(GLOWING_BOTTLED_BUTTERFLY_PROPERTIES));
        }
        return this.deferredRegister.register(registryId, () -> new BottledButterflyBlock(BOTTLED_BUTTERFLY_PROPERTIES));
    }

    private DeferredHolder<Block, Block> registerButterflyOrigami(String id) {
        return this.deferredRegister.register(id, ButterflyOrigamiBlock::new);
    }
}

