/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.registries.ItemRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class CreativeTabRegistry {
    private final DeferredRegister<CreativeModeTab> deferredRegister = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"butterflies");
    private DeferredHolder<CreativeModeTab, CreativeModeTab> butterflyCreativeTab;

    public CreativeTabRegistry(@NotNull IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise(@NotNull ItemRegistry itemRegistry) {
        if (this.butterflyCreativeTab != null) {
            throw new IllegalStateException("Creative tabs have already been initialised");
        }
        this.butterflyCreativeTab = this.deferredRegister.register("butterfly_creative_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.butterfly_tab")).icon(() -> ((Item)((Item)itemRegistry.getButterflyBook().get())).getDefaultInstance()).build());
    }

    @NotNull
    public DeferredHolder<CreativeModeTab, CreativeModeTab> getButterflyCreativeTab() {
        if (this.butterflyCreativeTab == null) {
            throw new IllegalStateException("Creative tab has not been initialised. Call initialise() first.");
        }
        return this.butterflyCreativeTab;
    }
}

