/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.registries.BlockRegistry;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.ButterflyEgg;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import com.bokmcdok.butterflies.world.entity.animal.Chrysalis;
import com.bokmcdok.butterflies.world.entity.animal.ParticleButterfly;
import com.bokmcdok.butterflies.world.entity.decoration.ButterflyScroll;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class EntityTypeRegistry {
    public static final MobCategory BUTTERFLY_SPAWN_POOL = MobCategory.valueOf((String)"BUTTERFLIES_BUTTERFLY_SPAWNS");
    private final DeferredRegister<EntityType<?>> deferredRegister = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"butterflies");
    private BlockRegistry blockRegistry;
    private List<DeferredHolder<EntityType<?>, EntityType<? extends Butterfly>>> butterflies;
    private List<DeferredHolder<EntityType<?>, EntityType<ButterflyEgg>>> butterflyEggs;
    private DeferredHolder<EntityType<?>, EntityType<IronGolem>> butterflyGolem;
    private DeferredHolder<EntityType<?>, EntityType<ButterflyScroll>> butterflyScroll;
    private List<DeferredHolder<EntityType<?>, EntityType<ButterflyScroll>>> butterflyScrolls;
    private List<DeferredHolder<EntityType<?>, EntityType<Caterpillar>>> caterpillars;
    private List<DeferredHolder<EntityType<?>, EntityType<Chrysalis>>> chrysalises;

    public EntityTypeRegistry(IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise(BlockRegistry blockRegistry) {
        this.blockRegistry = blockRegistry;
        int speciesCount = ButterflyInfo.SPECIES.length;
        this.butterflies = new ArrayList(speciesCount);
        this.butterflyEggs = new ArrayList(speciesCount);
        this.butterflyScrolls = new ArrayList(speciesCount);
        this.caterpillars = new ArrayList(speciesCount);
        this.chrysalises = new ArrayList(speciesCount);
        for (int i = 0; i < speciesCount; ++i) {
            this.butterflies.add(this.registerButterfly(i));
            this.butterflyEggs.add(this.registerButterflyEgg(i));
            this.butterflyScrolls.add(this.registerButterflyScroll(i));
            this.caterpillars.add(this.registerCaterpillar(i));
            this.chrysalises.add(this.registerChrysalis(i));
        }
        this.butterflyGolem = this.registerButterflyGolem();
        this.butterflyScroll = this.deferredRegister.register("butterfly_scroll", () -> EntityType.Builder.of(ButterflyScroll::create, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).build("butterfly_scroll"));
    }

    public List<DeferredHolder<EntityType<?>, EntityType<? extends Butterfly>>> getButterflies() {
        return this.butterflies;
    }

    public List<DeferredHolder<EntityType<?>, EntityType<ButterflyEgg>>> getButterflyEggs() {
        return this.butterflyEggs;
    }

    public DeferredHolder<EntityType<?>, EntityType<IronGolem>> getButterflyGolem() {
        return this.butterflyGolem;
    }

    public DeferredHolder<EntityType<?>, EntityType<ButterflyScroll>> getButterflyScroll() {
        return this.butterflyScroll;
    }

    public List<DeferredHolder<EntityType<?>, EntityType<ButterflyScroll>>> getButterflyScrolls() {
        return this.butterflyScrolls;
    }

    public List<DeferredHolder<EntityType<?>, EntityType<Caterpillar>>> getCaterpillars() {
        return this.caterpillars;
    }

    public List<DeferredHolder<EntityType<?>, EntityType<Chrysalis>>> getChrysalises() {
        return this.chrysalises;
    }

    private Butterfly createButterfly(EntityType<? extends Butterfly> entityType, Level level) {
        return new Butterfly(this.blockRegistry, entityType, level);
    }

    private Butterfly createIceButterfly(EntityType<? extends Butterfly> entityType, Level level) {
        return new ParticleButterfly(this.blockRegistry, entityType, level, ParticleTypes.ELECTRIC_SPARK);
    }

    private Butterfly createLavaMoth(EntityType<? extends Butterfly> entityType, Level level) {
        return new ParticleButterfly(this.blockRegistry, entityType, level, ParticleTypes.DRIPPING_DRIPSTONE_LAVA);
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull EntityType.EntityFactory<Butterfly> getEntityFactory(int butterflyIndex) {
        ButterflyData.Trait[] traits;
        for (ButterflyData.Trait trait : traits = ButterflyInfo.TRAITS[butterflyIndex]) {
            if (trait == ButterflyData.Trait.ICY) {
                return this::createIceButterfly;
            }
            if (trait != ButterflyData.Trait.LAVA) continue;
            return this::createLavaMoth;
        }
        return this::createButterfly;
    }

    private DeferredHolder<EntityType<?>, EntityType<? extends Butterfly>> registerButterfly(int butterflyIndex) {
        String registryId = Butterfly.getRegistryId(butterflyIndex);
        EntityType.EntityFactory<Butterfly> entityFactory = this.getEntityFactory(butterflyIndex);
        return this.deferredRegister.register(registryId, () -> EntityType.Builder.of((EntityType.EntityFactory)entityFactory, (MobCategory)BUTTERFLY_SPAWN_POOL).sized(0.3f, 0.2f).clientTrackingRange(10).build(registryId));
    }

    private DeferredHolder<EntityType<?>, EntityType<ButterflyEgg>> registerButterflyEgg(int butterflyIndex) {
        String registryId = ButterflyEgg.getRegistryId(butterflyIndex);
        return this.deferredRegister.register(registryId, () -> EntityType.Builder.of(ButterflyEgg::new, (MobCategory)BUTTERFLY_SPAWN_POOL).sized(0.1f, 0.1f).build(registryId));
    }

    private DeferredHolder<EntityType<?>, EntityType<IronGolem>> registerButterflyGolem() {
        String registryId = "butterfly_golem";
        return this.deferredRegister.register(registryId, () -> EntityType.Builder.of(IronGolem::new, (MobCategory)MobCategory.MISC).sized(1.4f, 2.7f).clientTrackingRange(10).build(registryId));
    }

    private DeferredHolder<EntityType<?>, EntityType<ButterflyScroll>> registerButterflyScroll(int butterflyIndex) {
        String registryId = ButterflyScroll.getRegistryId(butterflyIndex);
        return this.deferredRegister.register(registryId, () -> EntityType.Builder.of(ButterflyScroll::create, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).build(registryId));
    }

    private DeferredHolder<EntityType<?>, EntityType<Caterpillar>> registerCaterpillar(int butterflyIndex) {
        String registryId = Caterpillar.getRegistryId(butterflyIndex);
        return this.deferredRegister.register(registryId, () -> EntityType.Builder.of(Caterpillar::new, (MobCategory)BUTTERFLY_SPAWN_POOL).sized(0.1f, 0.1f).build(registryId));
    }

    private DeferredHolder<EntityType<?>, EntityType<Chrysalis>> registerChrysalis(int butterflyIndex) {
        String registryId = Chrysalis.getRegistryId(butterflyIndex);
        return this.deferredRegister.register(registryId, () -> EntityType.Builder.of(Chrysalis::new, (MobCategory)BUTTERFLY_SPAWN_POOL).sized(0.1f, 0.1f).build(registryId));
    }
}

