/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.ai;

import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class ButterflyMudPuddlingGoal
extends MoveToBlockGoal {
    private final Butterfly butterfly;

    public ButterflyMudPuddlingGoal(Butterfly mob, double speedModifier, int searchRange, int verticalSearchRange) {
        super((PathfinderMob)mob, speedModifier, searchRange, verticalSearchRange);
        this.butterfly = mob;
    }

    public double acceptedDistance() {
        return 2.0;
    }

    public boolean canContinueToUse() {
        return this.butterfly.getIsActive() && super.canContinueToUse();
    }

    public boolean canUse() {
        return this.butterfly.getIsActive() && super.canUse();
    }

    public boolean shouldRecalculatePath() {
        return this.tryTicks % 10 == 0;
    }

    public void tick() {
        ++this.tryTicks;
        if (this.isReachedTarget()) {
            this.butterfly.setAge(this.butterfly.getAge() - 2);
        }
        if (this.shouldRecalculatePath()) {
            this.moveMobToBlock();
        }
    }

    @NotNull
    public String toString() {
        return "Mud Puddle / Target = [" + String.valueOf(this.getMoveToTarget()) + "] / Position = [" + String.valueOf(this.butterfly.blockPosition()) + "] / Age = [" + this.butterfly.getAge() + "]";
    }

    protected boolean isReachedTarget() {
        return this.blockPos.closerToCenterThan((Position)this.butterfly.position(), this.acceptedDistance());
    }

    protected boolean isValidTarget(@NotNull LevelReader levelReader, @NotNull BlockPos blockPos) {
        if (levelReader.getBlockState(blockPos).is(Blocks.WATER)) {
            return levelReader.getBlockState(blockPos.north()).is(Blocks.MUD) || levelReader.getBlockState(blockPos.east()).is(Blocks.MUD) || levelReader.getBlockState(blockPos.south()).is(Blocks.MUD) || levelReader.getBlockState(blockPos.west()).is(Blocks.MUD);
        }
        return false;
    }

    protected void moveMobToBlock() {
        RandomSource random = this.mob.getRandom();
        this.mob.getNavigation().moveTo((double)this.blockPos.getX() + 3.0 * random.nextDouble() - 1.5, (double)this.blockPos.getY() + random.nextDouble() + 1.0, (double)this.blockPos.getZ() + 3.0 * random.nextDouble() - 1.5, this.speedModifier);
    }
}

