/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.animal;

import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.entity.DebugInfoSupplier;
import com.bokmcdok.butterflies.world.entity.animal.Chrysalis;
import com.bokmcdok.butterflies.world.entity.animal.DirectionalCreature;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Caterpillar
extends DirectionalCreature
implements DebugInfoSupplier {
    protected static final EntityDataAccessor<Boolean> DATA_IS_BOTTLED = SynchedEntityData.defineId(Caterpillar.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final String IS_BOTTLED = "is_bottled";
    private static final double CATERPILLAR_SPEED = 0.00325;
    @Nullable
    private Vec3 targetPosition;
    private boolean isNoGravity = true;

    public static String getRegistryId(int butterflyIndex) {
        return ButterflyInfo.SPECIES[butterflyIndex] + "_caterpillar";
    }

    public static void spawn(ServerLevel level, ResourceLocation location, BlockPos position, Direction direction, boolean isBottled) {
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(location);
        Entity entity = entityType.create((Level)level);
        if (entity instanceof Caterpillar) {
            Caterpillar caterpillar = (Caterpillar)entity;
            caterpillar.setIsBottled(isBottled);
            double x = (double)position.getX() + 0.45;
            double y = (double)position.getY() + 0.4;
            double z = (double)position.getZ() + 0.5;
            if (isBottled) {
                direction = Direction.DOWN;
                y = (double)position.getY() + 0.07;
                caterpillar.setInvulnerable(true);
                caterpillar.setPersistenceRequired();
            } else {
                switch (direction) {
                    case DOWN: {
                        y = position.getY();
                        break;
                    }
                    case UP: {
                        y = (double)position.getY() + 1.0;
                        break;
                    }
                    case NORTH: {
                        z = position.getZ();
                        break;
                    }
                    case SOUTH: {
                        z = (double)position.getZ() + 1.0;
                        break;
                    }
                    case WEST: {
                        x = position.getX();
                        break;
                    }
                    case EAST: {
                        x = (double)position.getX() + 1.0;
                    }
                }
            }
            caterpillar.moveTo(x, y, z, 0.0f, 0.0f);
            caterpillar.setSurfaceDirection(direction);
            caterpillar.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(position), MobSpawnType.NATURAL, null);
            level.addFreshEntity((Entity)caterpillar);
        }
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean(IS_BOTTLED, ((Boolean)this.entityData.get(DATA_IS_BOTTLED)).booleanValue());
    }

    public float getRenderScale() {
        float scale = (float)this.getAge() / -24000.0f;
        scale *= 0.04f;
        return (scale += 0.08f) * this.getData().getSizeMultiplier();
    }

    public boolean hurt(@NotNull DamageSource damageSource, float damage) {
        Entity entity = damageSource.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.level().isClientSide) {
                player.playSound(SoundEvents.PLAYER_ATTACK_SWEEP, 1.0f, 1.0f);
            } else {
                this.remove(Entity.RemovalReason.DISCARDED);
                Item caterpillarItem = (Item)BuiltInRegistries.ITEM.get(this.getData().getCaterpillarItem());
                ItemStack itemStack = new ItemStack((ItemLike)caterpillarItem);
                player.addItem(itemStack);
            }
            return true;
        }
        return super.hurt(damageSource, damage);
    }

    public boolean isFood(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public boolean isNoGravity() {
        return this.isNoGravity;
    }

    public boolean isPushable() {
        return false;
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains(IS_BOTTLED)) {
            this.entityData.set(DATA_IS_BOTTLED, (Object)tag.getBoolean(IS_BOTTLED));
        }
    }

    public void setAge(int age) {
        this.age = age;
    }

    public Caterpillar(EntityType<? extends Caterpillar> entityType, Level level) {
        super(entityType, level);
        this.setTexture("textures/entity/caterpillar/caterpillar_" + ButterflyData.getSpeciesString((LivingEntity)this) + ".png");
        this.setAge(-this.getData().caterpillarLifespan());
    }

    public void setPos(double x, double y, double z) {
        if (this.getX() == 0.0 && this.getY() == 0.0 && this.getZ() == 0.0) {
            super.setPos(x, y, z);
        }
        if (Mth.floor((double)x) == this.blockPosition().getX() && Mth.floor((double)y) == this.blockPosition().getY() && Mth.floor((double)z) == this.blockPosition().getZ()) {
            super.setPos(x, y, z);
        }
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        this.isNoGravity = true;
        if (this.getIsReleased()) {
            BlockPos surfaceBlockPos = this.getSurfaceBlockPos();
            if (this.level().hasChunkAt(surfaceBlockPos)) {
                if (this.level().isEmptyBlock(surfaceBlockPos)) {
                    this.setSurfaceDirection(Direction.DOWN);
                }
                if (this.getSurfaceDirection() == Direction.DOWN && (this.level().isEmptyBlock(surfaceBlockPos) || this.position().y() - (double)this.blockPosition().getY() > 0.01)) {
                    this.targetPosition = null;
                    this.isNoGravity = false;
                }
            }
        }
        if (this.isNoGravity()) {
            Direction direction = this.getSurfaceDirection();
            Direction.Axis axis = direction.getAxis();
            if (this.targetPosition == null || this.targetPosition.distanceToSqr(this.position()) < 0.007 || this.random.nextInt(30) == 0) {
                if (this.targetPosition == null) {
                    this.targetPosition = this.position();
                }
                this.targetPosition = axis == Direction.Axis.X ? new Vec3(this.targetPosition.x(), Math.floor(this.targetPosition.y()) + this.clampedRandomDouble(), Math.floor(this.targetPosition.z()) + this.clampedRandomDouble()) : (axis == Direction.Axis.Y ? new Vec3(Math.floor(this.targetPosition.x()) + this.clampedRandomDouble(), this.targetPosition.y(), Math.floor(this.targetPosition.z()) + this.clampedRandomDouble()) : new Vec3(Math.floor(this.targetPosition.x()) + this.clampedRandomDouble(), Math.floor(this.targetPosition.y()) + this.clampedRandomDouble(), this.targetPosition.z()));
            }
            Vec3 updatedDeltaMovement = this.getUpdatedDeltaMovement(axis);
            this.setDeltaMovement(updatedDeltaMovement);
            this.zza = 0.5f;
            double rotationDelta = this.getRotationDelta(direction, updatedDeltaMovement);
            this.setYRot(this.getYRot() + (float)rotationDelta);
            if (this.getIsReleased() && this.getAge() >= 0 && this.random.nextInt(0, 15) == 0) {
                BlockPos surfaceBlockPos = this.getSurfaceBlockPos();
                if (this.getData().isValidLandingBlock(this.level().getBlockState(surfaceBlockPos))) {
                    ResourceLocation newLocation = this.getData().getChrysalisEntity();
                    Chrysalis.spawn((ServerLevel)this.level(), newLocation, this.getSurfaceBlockPos(), this.getSurfaceDirection(), this.position(), this.getYRot());
                    this.remove(Entity.RemovalReason.DISCARDED);
                } else {
                    this.hurt(this.damageSources().starve(), 1.0f);
                }
            }
        }
    }

    @Override
    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_BOTTLED, (Object)false);
    }

    protected void doPush(@NotNull Entity otherEntity) {
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (this.getData().caterpillarSounds()) {
            return SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)ButterflyData.getSpeciesString((LivingEntity)this)));
        }
        return super.getAmbientSound();
    }

    @Override
    public String getDebugInfo() {
        return "Position = [" + String.format("%.3f", this.getX() % 1.0) + ", " + String.format("%.3f", this.getY() % 1.0) + ", " + String.format("%.3f", this.getZ() % 1.0) + "] / BlockPos = [" + String.valueOf(this.blockPosition()) + "] / SurfaceBlock = [" + String.valueOf(this.getSurfaceBlockPos()) + "] / SurfaceDirection = [" + this.getSurfaceDirection().getName() + "] / IsNoGravity = [" + this.isNoGravity + "]";
    }

    @Override
    protected boolean getIsReleased() {
        return (Boolean)this.entityData.get(DATA_IS_BOTTLED) == false;
    }

    @NotNull
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    protected void pushEntities() {
    }

    private double clampedDouble(double x) {
        return Math.max(0.05, Math.min(0.95, x));
    }

    private double clampedRandomDouble() {
        return this.clampedDouble(this.random.nextDouble() % 1.0);
    }

    private double getRotationDelta(Direction direction, Vec3 updatedDeltaMovement) {
        double updatedRotation = direction == Direction.DOWN ? Mth.atan2((double)updatedDeltaMovement.z, (double)updatedDeltaMovement.x) * 57.29577951308232 - 90.0 : (direction == Direction.UP ? Mth.atan2((double)updatedDeltaMovement.x(), (double)updatedDeltaMovement.z()) * 57.29577951308232 - 180.0 : (direction == Direction.NORTH ? Mth.atan2((double)updatedDeltaMovement.x(), (double)updatedDeltaMovement.y()) * 57.29577951308232 - 180.0 : (direction == Direction.SOUTH ? Mth.atan2((double)updatedDeltaMovement.y(), (double)updatedDeltaMovement.x()) * 57.29577951308232 - 90.0 : (direction == Direction.EAST ? Mth.atan2((double)updatedDeltaMovement.z(), (double)updatedDeltaMovement.y()) * 57.29577951308232 - 90.0 : Mth.atan2((double)updatedDeltaMovement.y, (double)updatedDeltaMovement.z) * 57.29577951308232))));
        return Mth.wrapDegrees((double)(updatedRotation - (double)this.getYRot()));
    }

    @NotNull
    private Vec3 getUpdatedDeltaMovement(Direction.Axis axis) {
        Vec3 updatedDeltaMovement = Vec3.ZERO;
        if (this.targetPosition != null) {
            Vec3 updatedMovementDelta = this.targetPosition.subtract(this.position()).add(0.1, 0.1, 0.1);
            double signumX = Math.signum(updatedMovementDelta.x);
            double signumY = Math.signum(updatedMovementDelta.y);
            double signumZ = Math.signum(updatedMovementDelta.z);
            Vec3 deltaMovement = this.getDeltaMovement();
            double xMod = 0.0;
            double yMod = 0.0;
            double zMod = 0.0;
            if (axis == Direction.Axis.X) {
                yMod = (signumY * 0.5 - deltaMovement.y) * 0.00325;
                zMod = (signumZ * 0.5 - deltaMovement.z) * 0.00325;
            } else if (axis == Direction.Axis.Y) {
                xMod = (signumX * 0.5 - deltaMovement.x) * 0.00325;
                zMod = (signumZ * 0.5 - deltaMovement.z) * 0.00325;
            } else {
                xMod = (signumX * 0.5 - deltaMovement.x) * 0.00325;
                yMod = (signumY * 0.5 - deltaMovement.y) * 0.00325;
            }
            updatedDeltaMovement = deltaMovement.add(xMod, yMod, zMod);
            if (this.getX() % 1.0 > 0.95 || this.getX() < 0.05) {
                updatedDeltaMovement.multiply(0.0, 1.0, 1.0);
            }
            if (this.getY() % 1.0 > 0.95 || this.getY() < 0.05) {
                updatedDeltaMovement.multiply(1.0, 0.0, 1.0);
            }
            if (this.getZ() % 1.0 > 0.95 || this.getZ() < 0.05) {
                updatedDeltaMovement.multiply(1.0, 1.0, 0.0);
            }
        }
        return updatedDeltaMovement;
    }

    private void setIsBottled(boolean isBottled) {
        this.entityData.set(DATA_IS_BOTTLED, (Object)isBottled);
    }
}

