/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.decoration;

import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.item.ButterflyScrollItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButterflyScroll
extends HangingEntity {
    private static final EntityDataAccessor<Integer> BUTTERFLY_INDEX = SynchedEntityData.defineId(ButterflyScroll.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final String NAME = "butterfly_scroll";

    public static String getRegistryId(int butterflyIndex) {
        return "butterfly_scroll_" + ButterflyInfo.SPECIES[butterflyIndex];
    }

    @NotNull
    public static ButterflyScroll create(EntityType<? extends ButterflyScroll> entityType, Level level) {
        return new ButterflyScroll(entityType, level);
    }

    public ButterflyScroll(EntityType<ButterflyScroll> entityType, Level level, BlockPos blockPos, Direction direction) {
        this(entityType, level);
        this.pos = blockPos;
        this.setDirection(direction);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putByte("Facing", (byte)this.direction.get3DDataValue());
        tag.putInt("CustomModelData", this.getButterflyIndex());
    }

    public void dropItem(@Nullable Entity entity) {
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)ButterflyScrollItem.getRegistryId(this.getButterflyIndex()));
            Item item = (Item)BuiltInRegistries.ITEM.get(location);
            ItemStack stack = new ItemStack((ItemLike)item);
            this.spawnAtLocation(stack);
        }
    }

    public int getButterflyIndex() {
        int result = ButterflyData.getButterflyIndex(this.getType().getDescriptionId());
        return result < 0 ? (Integer)this.entityData.get(BUTTERFLY_INDEX) : result;
    }

    public int getHeight() {
        return 14;
    }

    @NotNull
    public ResourceLocation getTextureLocation() {
        ButterflyData data = ButterflyData.getEntry(this.getButterflyIndex());
        return data == null ? ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)"textures/gui/butterfly_scroll/admiral.png") : data.getScrollTexture();
    }

    public int getWidth() {
        return 10;
    }

    public void playPlacementSound() {
        this.playSound(SoundEvents.ITEM_FRAME_PLACE, 1.0f, 1.0f);
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        builder.define(BUTTERFLY_INDEX, (Object)0);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setDirection(Direction.from3DDataValue((int)tag.getByte("Facing")));
        if (tag.contains("CustomModelData")) {
            this.setButterflyIndex(tag.getInt("CustomModelData"));
        }
    }

    @NotNull
    protected AABB calculateBoundingBox(@NotNull BlockPos pos, @NotNull Direction direction) {
        if (this.direction != null) {
            double x = (double)this.pos.getX() + 0.5 - (double)this.direction.getStepX() * 0.46875;
            double y = (double)this.pos.getY() + 0.5 - (double)this.direction.getStepY() * 0.46875;
            double z = (double)this.pos.getZ() + 0.5 - (double)this.direction.getStepZ() * 0.46875;
            this.setPosRaw(x, y, z);
            double width = this.getWidth();
            double height = this.getHeight();
            double breadth = this.getWidth();
            Direction.Axis axis = this.direction.getAxis();
            switch (axis) {
                case X: {
                    width = 1.0;
                    break;
                }
                case Y: {
                    height = 1.0;
                    break;
                }
                case Z: {
                    breadth = 1.0;
                    break;
                }
            }
            return new AABB(x - (width /= 32.0), y - (height /= 32.0), z - (breadth /= 32.0), x + width, y + height, z + breadth);
        }
        return null;
    }

    public void recreateFromPacket(@NotNull ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        int data = packet.getData();
        int direction = data >> 16 & 0xFFFF;
        this.setButterflyIndex(data & 0xFFFF);
        this.setDirection(Direction.from3DDataValue((int)direction));
    }

    public void setButterflyIndex(int index) {
        this.entityData.set(BUTTERFLY_INDEX, (Object)index);
    }

    protected void setDirection(@NotNull Direction direction) {
        this.direction = direction;
        this.setXRot(0.0f);
        this.setYRot(this.direction.get2DDataValue() * 90);
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
    }

    private ButterflyScroll(EntityType<? extends ButterflyScroll> entityType, Level level) {
        super(entityType, level);
    }
}

