/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.npc;

import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class SellingItemTrade
implements VillagerTrades.ItemListing {
    private final ItemStack givenItem;
    private final int emeraldCount;
    private final int sellingItemCount;
    private final int maxUses;
    private final int xpValue;
    private final float priceMultiplier;

    public SellingItemTrade(ItemLike givenItem, int emeraldCount, int sellingItemCount, int xpValue) {
        this(new ItemStack(givenItem), emeraldCount, sellingItemCount, 12, xpValue);
    }

    public SellingItemTrade(ItemStack givenItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
        this(givenItem, emeraldCount, sellingItemCount, maxUses, xpValue, 0.2f);
    }

    public SellingItemTrade(ItemStack givenItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue, float priceMultiplier) {
        this.givenItem = givenItem;
        this.emeraldCount = emeraldCount;
        this.sellingItemCount = sellingItemCount;
        this.maxUses = maxUses;
        this.xpValue = xpValue;
        this.priceMultiplier = priceMultiplier;
    }

    public MerchantOffer getOffer(@NotNull Entity trader, @NotNull RandomSource rand) {
        return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, this.emeraldCount), new ItemStack((ItemLike)this.givenItem.getItem(), this.sellingItemCount), this.maxUses, this.xpValue, this.priceMultiplier);
    }
}

