/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.inventory;

import com.bokmcdok.butterflies.registries.DataComponentRegistry;
import com.bokmcdok.butterflies.registries.ItemRegistry;
import com.bokmcdok.butterflies.world.block.ButterflyMicroscopeBlock;
import com.bokmcdok.butterflies.world.inventory.ButterflyBookResultSlot;
import com.bokmcdok.butterflies.world.inventory.ButterflyBookSlot;
import com.bokmcdok.butterflies.world.inventory.ButterflyScrollSlot;
import com.bokmcdok.butterflies.world.item.ButterflyBookItem;
import com.bokmcdok.butterflies.world.item.ButterflyScrollItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ButterflyMicroscopeMenu
extends AbstractContainerMenu {
    public static final int RESULT_SLOT = 0;
    private static final int CRAFT_SLOT_START = 1;
    private static final int CRAFT_SLOT_END = 3;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private final DataComponentRegistry dataComponentRegistry;
    private final ItemRegistry itemRegistry;
    private final CraftingContainer craftingContainer;
    private final ResultContainer resultContainer;
    private final ContainerLevelAccess containerLevelAccess;

    public ButterflyMicroscopeMenu(MenuType<?> menuType, int containerId, Inventory playerInventory) {
        this(null, null, menuType, containerId, playerInventory, ContainerLevelAccess.NULL);
    }

    public ButterflyMicroscopeMenu(DataComponentRegistry dataComponentRegistry, ItemRegistry itemRegistry, MenuType<?> menuType, int containerId, Inventory playerInventory, ContainerLevelAccess container) {
        super(menuType, containerId);
        int i;
        this.dataComponentRegistry = dataComponentRegistry;
        this.itemRegistry = itemRegistry;
        this.craftingContainer = new TransientCraftingContainer((AbstractContainerMenu)this, 2, 1);
        this.resultContainer = new ResultContainer();
        this.containerLevelAccess = container;
        this.addSlot(new ButterflyBookResultSlot(this.craftingContainer, (Container)this.resultContainer, 0, 204, 17));
        this.addSlot(new ButterflyBookSlot((Container)this.craftingContainer, 0, 132, 17));
        this.addSlot(new ButterflyScrollSlot((Container)this.craftingContainer, 1, 150, 17));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 96 + j * 18, i * 18 + 47));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 96 + i * 18, 105));
        }
    }

    public int getButterflyScrollIndex() {
        Item item;
        ItemStack scroll = this.craftingContainer.getItem(1);
        if (scroll != ItemStack.EMPTY && (item = scroll.getItem()) instanceof ButterflyScrollItem) {
            ButterflyScrollItem scrollItem = (ButterflyScrollItem)item;
            return scrollItem.getButterflyIndex();
        }
        return -1;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slotIndex) {
        ItemStack result = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot.hasItem()) {
            ItemStack slotItem = slot.getItem();
            result = slotItem.copy();
            if (slotIndex == 0) {
                this.containerLevelAccess.execute((level, blockPos) -> slotItem.getItem().onCraftedBy(slotItem, level, player));
                if (!this.moveItemStackTo(slotItem, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotItem, result);
            } else if (slotIndex >= 3 && slotIndex < 39 ? !this.moveItemStackTo(slotItem, 1, 3, false) && (slotIndex < 30 ? !this.moveItemStackTo(slotItem, 30, 39, false) : !this.moveItemStackTo(slotItem, 3, 30, false)) : !this.moveItemStackTo(slotItem, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (slotItem.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotItem.getCount() == result.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotItem);
            if (slotIndex == 0) {
                player.drop(slotItem, false);
            }
        }
        return result;
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.containerLevelAccess.execute((level, blockPos) -> this.clearContainer(player, (Container)this.craftingContainer));
    }

    public void slotsChanged(@NotNull Container container) {
        this.containerLevelAccess.execute((level, blockPos) -> this.onCraftingGridSlotChanged((Level)level, this.craftingContainer, this.resultContainer));
    }

    public boolean stillValid(@NotNull Player player) {
        return (Boolean)this.containerLevelAccess.evaluate((level, blockPos) -> level.getBlockState(blockPos).getBlock() instanceof ButterflyMicroscopeBlock && player.distanceToSqr((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5) <= 64.0, (Object)true);
    }

    private void onCraftingGridSlotChanged(Level level, CraftingContainer craftingContainer, ResultContainer resultContainer) {
        if (!level.isClientSide) {
            Item item;
            ItemStack scroll;
            ItemStack result = ItemStack.EMPTY;
            ItemStack book = craftingContainer.getItem(0);
            if (!book.isEmpty() && (scroll = craftingContainer.getItem(1)) != ItemStack.EMPTY && (item = scroll.getItem()) instanceof ButterflyScrollItem) {
                List pages;
                ButterflyScrollItem scrollItem = (ButterflyScrollItem)item;
                result = new ItemStack((ItemLike)this.itemRegistry.getButterflyBook().get());
                if (book.is((Item)this.itemRegistry.getButterflyBook().get()) && (pages = (List)book.get(this.dataComponentRegistry.getButterflyBookPages())) != null) {
                    result.set(this.dataComponentRegistry.getButterflyBookPages(), new ArrayList(pages));
                }
                if (!ButterflyBookItem.addPage(this.dataComponentRegistry, result, scrollItem.getButterflyIndex())) {
                    result = ItemStack.EMPTY;
                }
            }
            resultContainer.setItem(0, result);
        }
    }
}

