/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.item;

import com.bokmcdok.butterflies.client.gui.screens.ButterflyBookScreen;
import com.bokmcdok.butterflies.registries.DataComponentRegistry;
import com.bokmcdok.butterflies.world.ButterflyData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ButterflyBookItem
extends Item {
    public static final String NAME = "butterfly_book";
    private final DataComponentRegistry dataComponentRegistry;

    public static boolean addPage(DataComponentRegistry dataComponentRegistry, @NotNull ItemStack newBook, int index) {
        boolean result = false;
        List newPages = (List)newBook.getOrDefault(dataComponentRegistry.getButterflyBookPages(), new ArrayList());
        if (!newPages.contains(index)) {
            newPages.add(index);
            result = true;
        }
        int numButterflies = 0;
        int numMoths = 0;
        Iterator iterator = newPages.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            ButterflyData data = ButterflyData.getEntry(i);
            if (data == null) continue;
            if (data.type() == ButterflyData.ButterflyType.BUTTERFLY) {
                ++numButterflies;
                continue;
            }
            if (data.type() != ButterflyData.ButterflyType.MOTH) continue;
            ++numMoths;
        }
        newBook.set(dataComponentRegistry.getButterflyBookPages(), (Object)newPages);
        if (numButterflies >= ButterflyData.getNumButterflySpecies()) {
            CompoundTag filledButterfly = new CompoundTag();
            filledButterfly.putBoolean("filled_butterfly", true);
            newBook.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)filledButterfly));
        }
        if (numMoths >= ButterflyData.getNumMothSpecies()) {
            CompoundTag filledMoth = new CompoundTag();
            filledMoth.putBoolean("filled_moth", true);
            newBook.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)filledMoth));
        }
        return result;
    }

    public ButterflyBookItem(DataComponentRegistry dataComponentRegistry) {
        super(new Item.Properties().stacksTo(1));
        this.dataComponentRegistry = dataComponentRegistry;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        String localisation = "tooltip.butterflies.pages";
        List pages = (List)stack.getOrDefault(this.dataComponentRegistry.getButterflyBookPages(), new ArrayList());
        int numPages = 2 * pages.size();
        MutableComponent newComponent = Component.translatable((String)localisation, (Object[])new Object[]{numPages});
        Style style = newComponent.getStyle().withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.DARK_RED)).withItalic(Boolean.valueOf(true));
        newComponent.setStyle(style);
        components.add((Component)newComponent);
        super.appendHoverText(stack, context, components, tooltipFlag);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            this.openScreen(itemStack);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openScreen(ItemStack book) {
        Minecraft.getInstance().setScreen((Screen)new ButterflyBookScreen(this.dataComponentRegistry, book));
    }
}

