/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.gui.screens;

import com.bokmcdok.butterflies.world.ButterflyData;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ButterflyScrollScreen
extends Screen {
    private final int butterflyIndex;

    public ButterflyScrollScreen(int butterflyIndex) {
        super(GameNarrator.NO_TITLE);
        this.butterflyIndex = butterflyIndex;
    }

    protected void init() {
        super.init();
        this.createMenuControls();
    }

    protected void createMenuControls() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).bounds(this.width / 2 - 100, 196, 200, 20).build());
    }

    public void render(@NotNull GuiGraphics guiGraphics, int x, int y, float unknown) {
        super.render(guiGraphics, x, y, unknown);
        ButterflyData data = ButterflyData.getEntry(this.butterflyIndex);
        if (data != null) {
            int i = (this.width - 192) / 2;
            guiGraphics.blit(data.getScrollTexture(), i, 2, 0, 0, 192, 192);
        }
    }
}

