/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.gui.screens.inventory;

import com.bokmcdok.butterflies.client.texture.ButterflyTextures;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.inventory.ButterflyMicroscopeMenu;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ButterflyMicroscopeScreen
extends AbstractContainerScreen<ButterflyMicroscopeMenu> {
    private List<FormattedCharSequence> cachedPageComponents = Collections.emptyList();
    private int cachedButterflyIndex = -1;

    public ButterflyMicroscopeScreen(ButterflyMicroscopeMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.imageHeight = 128;
        this.inventoryLabelY = this.imageHeight - 92;
        this.titleLabelX = 96;
        this.inventoryLabelX = 96;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float unknown) {
        super.render(guiGraphics, mouseX, mouseY, unknown);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float unknown, int mouseX, int mouseY) {
        int x = this.width / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(ButterflyTextures.MICROSCOPE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        x = this.width / 2 - 176;
        y = (this.height - 192) / 2;
        ResourceLocation scrollTexture = ButterflyTextures.SCROLL;
        int butterflyIndex = ((ButterflyMicroscopeMenu)this.menu).getButterflyScrollIndex();
        if (butterflyIndex >= 0) {
            FormattedText formattedText;
            ButterflyData data = ButterflyData.getEntry(butterflyIndex);
            if (data != null && this.cachedButterflyIndex != butterflyIndex && (formattedText = ButterflyData.getFormattedButterflyData(butterflyIndex)) != null) {
                this.cachedPageComponents = this.font.split(formattedText, 114);
            }
        } else {
            this.cachedPageComponents = Collections.emptyList();
        }
        this.cachedButterflyIndex = butterflyIndex;
        guiGraphics.blit(scrollTexture, x, y, 0, 0, 192, 192);
        int cachedPageSize = Math.min(14, this.cachedPageComponents.size());
        for (int line = 0; line < cachedPageSize; ++line) {
            FormattedCharSequence formattedCharSequence = this.cachedPageComponents.get(line);
            guiGraphics.drawString(this.font, formattedCharSequence, x + 36, 50 + line * 9, 0, false);
        }
    }
}

