/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.event.village;

import com.bokmcdok.butterflies.registries.ItemRegistry;
import com.bokmcdok.butterflies.registries.VillagerProfessionRegistry;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import com.bokmcdok.butterflies.world.entity.npc.BuyingItemTrade;
import com.bokmcdok.butterflies.world.entity.npc.SellingItemTrade;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class VillageEventListener {
    private final ItemRegistry itemRegistry;
    private final VillagerProfessionRegistry villagerProfessionRegistry;

    public VillageEventListener(IEventBus forgeEventBus, ItemRegistry itemRegistry, VillagerProfessionRegistry villagerProfessionRegistry) {
        forgeEventBus.register((Object)this);
        this.itemRegistry = itemRegistry;
        this.villagerProfessionRegistry = villagerProfessionRegistry;
    }

    @SubscribeEvent
    private void onVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == this.villagerProfessionRegistry.getLepidopterist().get()) {
            Int2ObjectMap trades = event.getTrades();
            List tradesLevel1 = (List)trades.get(1);
            List tradesLevel2 = (List)trades.get(2);
            List tradesLevel3 = (List)trades.get(3);
            List tradesLevel4 = (List)trades.get(4);
            List tradesLevel5 = (List)trades.get(5);
            tradesLevel1.add(new SellingItemTrade((ItemLike)this.itemRegistry.getEmptyButterflyNet().get(), 5, 1, 1));
            tradesLevel3.add(new SellingItemTrade((ItemLike)this.itemRegistry.getSilk().get(), 32, 8, 10));
            tradesLevel5.add(new SellingItemTrade((ItemLike)this.itemRegistry.getButterflyBannerPattern().get(), 8, 1, 30));
            tradesLevel5.add(new SellingItemTrade((ItemLike)this.itemRegistry.getZhuangziBook().get(), 35, 1, 30));
            List<DeferredHolder<Item, Item>> bottledButterflies = this.itemRegistry.getBottledButterflies();
            List<DeferredHolder<Item, Item>> bottledCaterpillars = this.itemRegistry.getBottledCaterpillars();
            List<DeferredHolder<Item, Item>> butterflyEggs = this.itemRegistry.getButterflyEggs();
            List<DeferredHolder<Item, Item>> butterflyScrolls = this.itemRegistry.getButterflyScrolls();
            List<DeferredHolder<Item, Item>> caterpillars = this.itemRegistry.getCaterpillars();
            block5: for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                if (ButterflySpeciesList.TYPES[i] == ButterflyData.ButterflyType.SPECIAL) continue;
                switch (ButterflySpeciesList.RARITIES[i]) {
                    case COMMON: {
                        tradesLevel1.add(new BuyingItemTrade((ItemLike)butterflyEggs.get(i).get(), 15, 16, 2));
                        tradesLevel1.add(new SellingItemTrade((ItemLike)butterflyEggs.get(i).get(), 6, 1, 1));
                        tradesLevel2.add(new SellingItemTrade((ItemLike)bottledCaterpillars.get(i).get(), 10, 1, 5));
                        tradesLevel2.add(new SellingItemTrade((ItemLike)butterflyScrolls.get(i).get(), 15, 1, 5));
                        tradesLevel2.add(new BuyingItemTrade((ItemLike)caterpillars.get(i).get(), 10, 12, 10));
                        tradesLevel2.add(new SellingItemTrade((ItemLike)caterpillars.get(i).get(), 8, 1, 5));
                        tradesLevel3.add(new SellingItemTrade((ItemLike)bottledButterflies.get(i).get(), 15, 1, 10));
                        continue block5;
                    }
                    case UNCOMMON: {
                        tradesLevel2.add(new BuyingItemTrade((ItemLike)butterflyEggs.get(i).get(), 15, 12, 1));
                        tradesLevel2.add(new SellingItemTrade((ItemLike)butterflyEggs.get(i).get(), 8, 1, 1));
                        tradesLevel3.add(new SellingItemTrade((ItemLike)bottledCaterpillars.get(i).get(), 15, 1, 10));
                        tradesLevel3.add(new SellingItemTrade((ItemLike)butterflyScrolls.get(i).get(), 20, 1, 10));
                        tradesLevel3.add(new BuyingItemTrade((ItemLike)caterpillars.get(i).get(), 8, 12, 20));
                        tradesLevel3.add(new SellingItemTrade((ItemLike)caterpillars.get(i).get(), 10, 1, 10));
                        tradesLevel4.add(new SellingItemTrade((ItemLike)bottledButterflies.get(i).get(), 20, 1, 15));
                        continue block5;
                    }
                    case RARE: {
                        tradesLevel3.add(new BuyingItemTrade((ItemLike)butterflyEggs.get(i).get(), 10, 1, 20));
                        tradesLevel3.add(new SellingItemTrade((ItemLike)butterflyEggs.get(i).get(), 10, 1, 10));
                        tradesLevel4.add(new SellingItemTrade((ItemLike)bottledCaterpillars.get(i).get(), 20, 1, 15));
                        tradesLevel4.add(new SellingItemTrade((ItemLike)butterflyScrolls.get(i).get(), 32, 1, 15));
                        tradesLevel4.add(new BuyingItemTrade((ItemLike)caterpillars.get(i).get(), 6, 1, 30));
                        tradesLevel4.add(new SellingItemTrade((ItemLike)caterpillars.get(i).get(), 15, 1, 15));
                        tradesLevel5.add(new SellingItemTrade((ItemLike)bottledButterflies.get(i).get(), 32, 1, 30));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    private void onWandererTrades(WandererTradesEvent event) {
        List genericTrades = event.getGenericTrades();
        List<DeferredHolder<Item, Item>> bottledButterflies = this.itemRegistry.getBottledButterflies();
        for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
            if (ButterflySpeciesList.TYPES[i] == ButterflyData.ButterflyType.SPECIAL || Objects.requireNonNull(ButterflySpeciesList.RARITIES[i]) != ButterflyData.Rarity.UNCOMMON) continue;
            genericTrades.add(new SellingItemTrade((ItemLike)bottledButterflies.get(i).get(), 20, 1, 30));
        }
    }
}

