/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.block;

import com.bokmcdok.butterflies.registries.BlockRegistry;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BottledCaterpillarBlock
extends Block {
    private static final String NAME = "block.butterflies.bottled_caterpillar";
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)5.0, (double)0.0, (double)5.0, (double)10.0, (double)1.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)1.0, (double)4.0, (double)11.0, (double)2.0, (double)11.0), Block.box((double)3.0, (double)2.0, (double)3.0, (double)12.0, (double)6.0, (double)12.0), Block.box((double)4.0, (double)6.0, (double)4.0, (double)11.0, (double)7.0, (double)11.0), Block.box((double)5.0, (double)7.0, (double)5.0, (double)10.0, (double)8.0, (double)10.0), Block.box((double)6.0, (double)8.0, (double)6.0, (double)9.0, (double)10.0, (double)9.0), Block.box((double)5.0, (double)10.0, (double)5.0, (double)10.0, (double)12.0, (double)10.0), Block.box((double)6.0, (double)12.0, (double)6.0, (double)9.0, (double)13.0, (double)9.0)});

    public BottledCaterpillarBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).isRedstoneConductor(BlockRegistry::never).isSuffocating(BlockRegistry::never).isValidSpawn(BlockRegistry::never).isViewBlocking(BlockRegistry::never).noOcclusion().sound(SoundType.GLASS).strength(0.3f));
    }

    public void destroy(@NotNull LevelAccessor level, @NotNull BlockPos position, @NotNull BlockState state) {
        super.destroy(level, position, state);
        this.removeEntity(level, position, Entity.RemovalReason.DISCARDED);
    }

    @NotNull
    public MutableComponent getName() {
        return Component.translatable((String)NAME);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos position, @NotNull CollisionContext collisionContext) {
        return SHAPE;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    public void onRemove(@NotNull BlockState oldBlockState, @NotNull Level level, @NotNull BlockPos position, @NotNull BlockState newBlockState, boolean flag) {
        super.onRemove(oldBlockState, level, position, newBlockState, flag);
        this.removeEntity((LevelAccessor)level, position, Entity.RemovalReason.KILLED);
    }

    private void removeEntity(LevelAccessor level, BlockPos position, Entity.RemovalReason reason) {
        AABB aabb = new AABB(position);
        List entities = level.getEntitiesOfClass(Caterpillar.class, aabb);
        for (Caterpillar i : entities) {
            i.remove(reason);
        }
    }
}

