/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.block;

import com.bokmcdok.butterflies.registries.BlockEntityTypeRegistry;
import com.bokmcdok.butterflies.registries.BlockRegistry;
import com.bokmcdok.butterflies.registries.MenuTypeRegistry;
import com.bokmcdok.butterflies.world.block.entity.ButterflyFeederEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButterflyFeederBlock
extends BaseEntityBlock {
    private static final MapCodec<ButterflyFeederBlock> CODEC = ButterflyFeederBlock.simpleCodec(x -> new ButterflyFeederBlock(null, null));
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)2.0), (VoxelShape[])new VoxelShape[]{Block.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)15.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)14.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)14.0, (double)0.0, (double)15.0, (double)16.0, (double)1.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)2.0)});
    private final BlockEntityTypeRegistry blockEntityTypeRegistry;
    private final MenuTypeRegistry menuTypeRegistry;

    public ButterflyFeederBlock(BlockEntityTypeRegistry blockEntityTypeRegistry, MenuTypeRegistry menuTypeRegistry) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).isRedstoneConductor(BlockRegistry::never).isSuffocating(BlockRegistry::never).isValidSpawn(BlockRegistry::never).isViewBlocking(BlockRegistry::never).noOcclusion().sound(SoundType.BAMBOO).strength(0.3f));
        this.blockEntityTypeRegistry = blockEntityTypeRegistry;
        this.menuTypeRegistry = menuTypeRegistry;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos position, @NotNull CollisionContext collisionContext) {
        return SHAPE;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, BlockState newBlockState, boolean unknown) {
        if (!blockState.is(newBlockState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof Container) {
                Containers.dropContents((Level)level, (BlockPos)blockPos, (Container)((Container)blockEntity));
                level.updateNeighbourForOutputSignal(blockPos, (Block)this);
            }
            super.onRemove(blockState, level, blockPos, newBlockState, unknown);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new ButterflyFeederEntity(this.menuTypeRegistry, (BlockEntityType)this.blockEntityTypeRegistry.getButterflyFeeder().get(), blockPos, blockState);
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ButterflyFeederEntity) {
            ButterflyFeederEntity feederEntity = (ButterflyFeederEntity)blockEntity;
            player.openMenu((MenuProvider)feederEntity);
        }
        return InteractionResult.CONSUME;
    }
}

