/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.ai;

import com.bokmcdok.butterflies.config.ButterfliesConfig;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.ButterflyEgg;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ButterflyLayEggGoal
extends MoveToBlockGoal {
    private final Butterfly butterfly;

    public ButterflyLayEggGoal(Butterfly mob, double speedModifier, int searchRange, int verticalSearchRange) {
        super((PathfinderMob)mob, speedModifier, searchRange, verticalSearchRange);
        this.butterfly = mob;
    }

    public boolean canContinueToUse() {
        return this.butterfly.getIsActive() && super.canContinueToUse();
    }

    public boolean canUse() {
        return this.butterfly.getIsActive() && this.butterfly.getIsFertile() && super.canUse();
    }

    public void start() {
        super.start();
    }

    public void stop() {
        this.butterfly.setLanded(false);
        super.stop();
    }

    public void tick() {
        super.tick();
        if (this.isReachedTarget()) {
            this.tryTicks -= 11;
            Vec3 deltaMovement = this.butterfly.getDeltaMovement();
            this.butterfly.setLanded(true);
            this.butterfly.setDeltaMovement(0.0, deltaMovement.y, 0.0);
            if (this.butterfly.getIsFertile()) {
                List numButterflies = this.butterfly.level().getNearbyEntities(Butterfly.class, TargetingConditions.forNonCombat(), (LivingEntity)this.butterfly, this.butterfly.getBoundingBox().inflate(32.0));
                int maxDensity = (Integer)ButterfliesConfig.maxDensity.get();
                if (maxDensity == 0 || numButterflies.size() <= maxDensity) {
                    Direction direction;
                    switch (this.butterfly.getRandom().nextInt(6)) {
                        default: {
                            Direction direction2 = Direction.UP;
                            break;
                        }
                        case 1: {
                            Direction direction2 = Direction.DOWN;
                            break;
                        }
                        case 2: {
                            Direction direction2 = Direction.NORTH;
                            break;
                        }
                        case 3: {
                            Direction direction2 = Direction.EAST;
                            break;
                        }
                        case 4: {
                            Direction direction2 = Direction.SOUTH;
                            break;
                        }
                        case 5: {
                            Direction direction2 = direction = Direction.WEST;
                        }
                    }
                    if (this.butterfly.level().getBlockState(this.blockPos.relative(direction)).isAir()) {
                        ResourceLocation eggEntity = this.butterfly.getData().getButterflyEggEntity();
                        ButterflyEgg.spawn((ServerLevel)this.butterfly.level(), eggEntity, this.blockPos, direction);
                        this.butterfly.setIsFertile(false);
                        this.butterfly.useEgg();
                    }
                }
            }
        } else {
            this.tryTicks += 11;
        }
    }

    @NotNull
    public String toString() {
        return "Lay Egg / Target = [" + String.valueOf(this.getMoveToTarget()) + "] / Reached Target = [" + this.isReachedTarget() + "] / Landed = [" + this.butterfly.getIsLanded() + "] / Fertile = [" + this.butterfly.getIsFertile() + "] / Num Eggs = [" + this.butterfly.getNumEggs() + "]";
    }

    protected boolean isValidTarget(@NotNull LevelReader levelReader, @NotNull BlockPos blockPos) {
        if (!levelReader.isEmptyBlock(blockPos.above())) {
            return false;
        }
        if (this.butterfly.isValidLandingBlock(levelReader.getBlockState(blockPos))) {
            return blockPos.getY() < this.butterfly.getBlockY();
        }
        return false;
    }
}

