/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.animal;

import com.bokmcdok.butterflies.config.ButterfliesConfig;
import com.bokmcdok.butterflies.registries.BlockRegistry;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import com.bokmcdok.butterflies.world.entity.DebugInfoSupplier;
import com.bokmcdok.butterflies.world.entity.ai.ButterflyEatCropGoal;
import com.bokmcdok.butterflies.world.entity.ai.ButterflyLayEggGoal;
import com.bokmcdok.butterflies.world.entity.ai.ButterflyMatingGoal;
import com.bokmcdok.butterflies.world.entity.ai.ButterflyPollinateFlowerGoal;
import com.bokmcdok.butterflies.world.entity.ai.ButterflyRestGoal;
import com.bokmcdok.butterflies.world.entity.ai.ButterflyWanderGoal;
import com.bokmcdok.butterflies.world.entity.ai.MothWanderGoal;
import com.bokmcdok.butterflies.world.entity.animal.ButterflyEgg;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import com.bokmcdok.butterflies.world.entity.animal.Chrysalis;
import java.util.Calendar;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Butterfly
extends Animal
implements DebugInfoSupplier {
    protected static final EntityDataAccessor<Boolean> DATA_IS_FERTILE = SynchedEntityData.defineId(Butterfly.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> DATA_LANDED = SynchedEntityData.defineId(Butterfly.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Integer> DATA_NUM_EGGS = SynchedEntityData.defineId(Butterfly.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<String> DATA_GOAL_STATE = SynchedEntityData.defineId(Butterfly.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    protected static final String IS_FERTILE = "is_fertile";
    protected static final String LANDED = "landed";
    protected static final String NUM_EGGS = "num_eggs";
    private static final int TICKS_PER_FLAP = Mth.ceil((float)2.4166098f);
    private static final double BUTTERFLY_SPEED = 1.8;
    private ButterflyData data = null;
    private final ResourceLocation texture;
    private final BlockRegistry blockRegistry;

    public static boolean checkButterflySpawnRules(EntityType<? extends Butterfly> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource rng) {
        return true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 3.0).add(Attributes.FLYING_SPEED, 1.8).add(Attributes.MOVEMENT_SPEED, 9.0);
    }

    public static String getRegistryId(int butterflyIndex) {
        return ButterflySpeciesList.SPECIES[butterflyIndex];
    }

    public static void spawn(Level level, ResourceLocation location, BlockPos position, Boolean placed) {
        if (level instanceof ServerLevel) {
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(location);
            Entity entity = entityType.create(level);
            if (entity instanceof Butterfly) {
                Butterfly butterfly = (Butterfly)entity;
                butterfly.moveTo((double)position.getX() + 0.45, (double)position.getY() + 0.2, (double)position.getZ() + 0.5, 0.0f, 0.0f);
                butterfly.setYBodyRot(butterfly.random.nextFloat());
                butterfly.finalizeSpawn((ServerLevelAccessor)((ServerLevel)level), level.getCurrentDifficultyAt(position), MobSpawnType.NATURAL, null);
                if (placed.booleanValue() || butterfly.getData().getOverallLifeSpan() == ButterflyData.Lifespan.IMMORTAL) {
                    butterfly.setInvulnerable(true);
                    butterfly.setPersistenceRequired();
                }
                level.addFreshEntity((Entity)butterfly);
            }
        } else {
            level.playSound(null, (double)position.getX(), (double)position.getY(), (double)position.getZ(), SoundEvents.PLAYER_ATTACK_WEAK, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    private static boolean isScaredOfEverything(LivingEntity entity) {
        return !(entity instanceof Butterfly) && !(entity instanceof Caterpillar) && !(entity instanceof ButterflyEgg) && !(entity instanceof Chrysalis);
    }

    private static boolean isNotScaredOfCats(LivingEntity entity) {
        return !(entity instanceof Butterfly) && !(entity instanceof Caterpillar) && !(entity instanceof ButterflyEgg) && !(entity instanceof Chrysalis) && !(entity instanceof Cat);
    }

    public Butterfly(BlockRegistry blockRegistry, EntityType<? extends Butterfly> entityType, Level level) {
        super(entityType, level);
        Calendar calendar;
        this.blockRegistry = blockRegistry;
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.setNoGravity(true);
        String species = ButterflyData.getSpeciesString((LivingEntity)this);
        if (species.contains("christmas") && (calendar = Calendar.getInstance()).get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            species = "christmas_alt";
        }
        this.texture = ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)("textures/entity/butterfly/butterfly_" + species + ".png"));
        this.setAge(-this.getData().butterflyLifespan());
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean(IS_FERTILE, ((Boolean)this.entityData.get(DATA_IS_FERTILE)).booleanValue());
        tag.putBoolean(LANDED, ((Boolean)this.entityData.get(DATA_LANDED)).booleanValue());
        tag.putInt(NUM_EGGS, ((Integer)this.entityData.get(DATA_NUM_EGGS)).intValue());
    }

    public boolean causeFallDamage(float fallDistance, float blockModifier, @NotNull DamageSource damageSource) {
        return false;
    }

    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor levelAccessor, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        if (spawnType == MobSpawnType.SPAWN_EGG) {
            this.setPersistenceRequired();
        }
        int numEggs = (Integer)ButterfliesConfig.eggLimit.get();
        if (this.random.nextDouble() < (Double)ButterfliesConfig.doubleEggChance.get()) {
            numEggs *= 2;
        }
        switch (this.getData().eggMultiplier()) {
            case NONE: {
                numEggs = 0;
                break;
            }
            case NORMAL: {
                break;
            }
            case DOUBLE: {
                numEggs *= 2;
            }
        }
        this.setNumEggs(numEggs);
        return super.finalizeSpawn(levelAccessor, difficulty, spawnType, groupData);
    }

    public BlockRegistry getBlockRegistry() {
        return this.blockRegistry;
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob mob) {
        return null;
    }

    public int getButterflyIndex() {
        return this.getData().butterflyIndex();
    }

    @Override
    public String getDebugInfo() {
        return (String)this.entityData.get(DATA_GOAL_STATE);
    }

    public boolean getIsActive() {
        switch (this.getData().diurnality()) {
            case DIURNAL: {
                return this.level().isDay();
            }
            case NOCTURNAL: {
                return this.level().isNight();
            }
            case CREPUSCULAR: {
                return !this.level().dimensionType().hasFixedTime() && this.level().getSkyDarken() == 4;
            }
        }
        return true;
    }

    public boolean getIsFertile() {
        return this.getNumEggs() > 0 && (Boolean)this.entityData.get(DATA_IS_FERTILE) != false;
    }

    public boolean getIsLanded() {
        return (Boolean)this.entityData.get(DATA_LANDED);
    }

    public boolean getIsMoth() {
        return this.getData().type() == ButterflyData.ButterflyType.MOTH;
    }

    public int getNumEggs() {
        return (Integer)this.entityData.get(DATA_NUM_EGGS);
    }

    public float getRenderScale() {
        switch (this.getData().size()) {
            case TINY: {
                return 0.15f;
            }
            case SMALL: {
                return 0.25f;
            }
            case LARGE: {
                return 0.45f;
            }
            case HUGE: {
                return 0.55f;
            }
        }
        return 0.35f;
    }

    public boolean isFood(@NotNull ItemStack stack) {
        ResourceLocation location = this.getData().preferredFlower();
        Item item = (Item)BuiltInRegistries.ITEM.get(location);
        return stack.is(item);
    }

    public boolean isValidLandingBlock(BlockState blockState) {
        return this.getData().isValidLandingBlock(blockState);
    }

    public void tick() {
        super.tick();
        this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand interactionHand) {
        ItemStack itemstack = player.getItemInHand(interactionHand);
        if (this.getData().eggMultiplier() != ButterflyData.EggMultiplier.NONE && this.isFood(itemstack)) {
            if (!this.level().isClientSide && this.getNumEggs() == 0) {
                this.usePlayerItem(player, interactionHand, itemstack);
                this.setNumEggs(1);
                return InteractionResult.SUCCESS;
            }
            if (this.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level);
        if (this.getData().speed() == ButterflyData.Speed.FAST) {
            navigation.setSpeedModifier(1.2);
        }
        navigation.setCanOpenDoors(false);
        navigation.setCanFloat(false);
        navigation.setCanPassDoors(true);
        return navigation;
    }

    protected boolean isFlapping() {
        return this.tickCount % TICKS_PER_FLAP == 0;
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains(IS_FERTILE)) {
            this.entityData.set(DATA_IS_FERTILE, (Object)tag.getBoolean(IS_FERTILE));
        }
        if (tag.contains(LANDED)) {
            this.entityData.set(DATA_LANDED, (Object)tag.getBoolean(LANDED));
        }
        if (tag.contains(NUM_EGGS)) {
            this.entityData.set(DATA_NUM_EGGS, (Object)tag.getInt(NUM_EGGS));
        }
    }

    protected void registerGoals() {
        super.registerGoals();
        if (Objects.equals(this.getData().entityId(), "forester")) {
            this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 3.0f, 0.8, 1.33, Butterfly::isNotScaredOfCats));
        } else {
            this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 3.0f, 0.8, 1.33, Butterfly::isScaredOfEverything));
        }
        this.goalSelector.addGoal(2, (Goal)new ButterflyLayEggGoal(this, 0.8, 8, 8));
        this.goalSelector.addGoal(2, (Goal)new ButterflyMatingGoal(this, 1.1, 8.0f));
        if (((Boolean)ButterfliesConfig.enablePollination.get()).booleanValue()) {
            switch (this.getData().plantEffect()) {
                case NONE: {
                    break;
                }
                case POLLINATE: {
                    this.goalSelector.addGoal(4, (Goal)new ButterflyPollinateFlowerGoal(this, 0.8, 8, 8));
                    break;
                }
                case CONSUME: {
                    this.goalSelector.addGoal(4, (Goal)new ButterflyEatCropGoal(this, 0.8, 8, 8));
                }
            }
        }
        this.goalSelector.addGoal(6, (Goal)new ButterflyRestGoal(this, 0.8, 8, 8));
        if (this.getData().type() == ButterflyData.ButterflyType.MOTH || Objects.equals(this.getData().entityId(), "heath")) {
            this.goalSelector.addGoal(8, (Goal)new MothWanderGoal(this, 1.0));
        } else {
            this.goalSelector.addGoal(8, (Goal)new ButterflyWanderGoal(this, 1.0));
        }
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Butterfly.class, true, target -> {
            if (target instanceof Butterfly) {
                Butterfly butterfly = (Butterfly)target;
                return butterfly.getButterflyIndex() == this.getData().getMateButterflyIndex() && butterfly.getNumEggs() > 0 && !butterfly.getIsFertile();
            }
            return false;
        }));
    }

    public void setAge(int age) {
        this.age = age;
    }

    public void setIsFertile(boolean isFertile) {
        this.entityData.set(DATA_IS_FERTILE, (Object)isFertile);
    }

    public void setLanded(boolean landed) {
        this.entityData.set(DATA_LANDED, (Object)landed);
        this.setNoGravity(!landed);
    }

    public void setNumEggs(int numEggs) {
        this.entityData.set(DATA_NUM_EGGS, (Object)Math.max(0, numEggs));
    }

    public void setGoalState(String goalState) {
        this.entityData.set(DATA_GOAL_STATE, (Object)goalState);
    }

    public void setPos(double x, double y, double z) {
        Vec3 delta = new Vec3(x, y, z).subtract(this.position());
        if (delta.lengthSqr() <= 1.0 || this.position().lengthSqr() == 0.0) {
            super.setPos(x, y, z);
        }
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize();
        if (d0 < 1.0) {
            d0 = 1.0;
        }
        return distance < (d0 *= 64.0 * Butterfly.getViewScale()) * d0;
    }

    public void useEgg() {
        this.setNumEggs(this.getNumEggs() - 1);
    }

    protected void checkFallDamage(double yPos, boolean onGround, @NotNull BlockState blockState, @NotNull BlockPos position) {
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (((Boolean)ButterfliesConfig.enableLifespan.get()).booleanValue() && this.getData().getOverallLifeSpan() != ButterflyData.Lifespan.IMMORTAL && !this.isPersistenceRequired() && this.getAge() >= 0 && this.random.nextInt(0, 15) == 0) {
            this.kill();
        }
        if (((Boolean)ButterfliesConfig.debugInformation.get()).booleanValue()) {
            WrappedGoal[] runningGoals;
            StringBuilder debugOutput = new StringBuilder();
            for (WrappedGoal goal : runningGoals = (WrappedGoal[])this.goalSelector.getAvailableGoals().toArray(WrappedGoal[]::new)) {
                debugOutput.append(goal.getGoal());
                debugOutput.append(" / ");
            }
            this.setGoalState(debugOutput.toString());
        }
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_FERTILE, (Object)false);
        builder.define(DATA_LANDED, (Object)false);
        builder.define(DATA_NUM_EGGS, (Object)1);
        builder.define(DATA_GOAL_STATE, (Object)"");
    }

    protected void doPush(@NotNull Entity otherEntity) {
    }

    @NotNull
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (this.getIsActive() && this.getData().butterflySounds()) {
            return SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)ButterflyData.getSpeciesString((LivingEntity)this)));
        }
        return super.getAmbientSound();
    }

    protected float getSoundVolume() {
        return 0.2f;
    }

    protected void pushEntities() {
    }

    public ButterflyData getData() {
        if (this.data == null) {
            this.data = ButterflyData.getButterflyDataForEntity((LivingEntity)this);
        }
        return this.data;
    }
}

