/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.decoration;

import com.bokmcdok.butterflies.registries.EntityTypeRegistry;
import com.bokmcdok.butterflies.registries.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButterflyScroll
extends HangingEntity {
    private static final EntityDataAccessor<Integer> BUTTERFLY_INDEX = SynchedEntityData.defineId(ButterflyScroll.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private ItemRegistry itemRegistry;
    public static final String NAME = "butterfly_scroll";

    @NotNull
    public static ButterflyScroll create(EntityType<? extends ButterflyScroll> entityType, Level level) {
        return new ButterflyScroll(entityType, level);
    }

    public ButterflyScroll(EntityTypeRegistry entityTypeRegistry, ItemRegistry itemRegistry, Level level, BlockPos blockPos, Direction direction) {
        this((EntityType<? extends ButterflyScroll>)((EntityType)entityTypeRegistry.getButterflyScroll().get()), level);
        this.itemRegistry = itemRegistry;
        this.pos = blockPos;
        this.setDirection(direction);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putByte("Facing", (byte)this.direction.get3DDataValue());
        tag.putInt("CustomModelData", this.getButterflyIndex());
    }

    public void dropItem(@Nullable Entity entity) {
        ItemStack stack = new ItemStack((ItemLike)this.itemRegistry.getButterflyScrolls().get(this.getButterflyIndex()).get());
        this.spawnAtLocation(stack);
    }

    public int getButterflyIndex() {
        return (Integer)this.entityData.get(BUTTERFLY_INDEX);
    }

    public int getHeight() {
        return 14;
    }

    public int getWidth() {
        return 10;
    }

    public void playPlacementSound() {
        this.playSound(SoundEvents.ITEM_FRAME_PLACE, 1.0f, 1.0f);
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        builder.define(BUTTERFLY_INDEX, (Object)0);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setDirection(Direction.from3DDataValue((int)tag.getByte("Facing")));
        if (tag.contains("CustomModelData")) {
            this.setButterflyIndex(tag.getInt("CustomModelData"));
        }
    }

    @NotNull
    protected AABB calculateBoundingBox(@NotNull BlockPos pos, @NotNull Direction direction) {
        if (this.direction != null) {
            double x = (double)this.pos.getX() + 0.5 - (double)this.direction.getStepX() * 0.46875;
            double y = (double)this.pos.getY() + 0.5 - (double)this.direction.getStepY() * 0.46875;
            double z = (double)this.pos.getZ() + 0.5 - (double)this.direction.getStepZ() * 0.46875;
            this.setPosRaw(x, y, z);
            double width = this.getWidth();
            double height = this.getHeight();
            double breadth = this.getWidth();
            Direction.Axis axis = this.direction.getAxis();
            switch (axis) {
                case X: {
                    width = 1.0;
                    break;
                }
                case Y: {
                    height = 1.0;
                    break;
                }
                case Z: {
                    breadth = 1.0;
                    break;
                }
            }
            return new AABB(x - (width /= 32.0), y - (height /= 32.0), z - (breadth /= 32.0), x + width, y + height, z + breadth);
        }
        return null;
    }

    public void recreateFromPacket(@NotNull ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        int data = packet.getData();
        int direction = data >> 16 & 0xFFFF;
        this.setButterflyIndex(data & 0xFFFF);
        this.setDirection(Direction.from3DDataValue((int)direction));
    }

    public void setButterflyIndex(int index) {
        this.entityData.set(BUTTERFLY_INDEX, (Object)index);
    }

    protected void setDirection(@NotNull Direction direction) {
        this.direction = direction;
        this.setXRot(0.0f);
        this.setYRot(this.direction.get2DDataValue() * 90);
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
    }

    private ButterflyScroll(EntityType<? extends ButterflyScroll> entityType, Level level) {
        super(entityType, level);
    }
}

