/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.item;

import com.bokmcdok.butterflies.client.gui.screens.ButterflyScrollScreen;
import com.bokmcdok.butterflies.registries.DataComponentRegistry;
import com.bokmcdok.butterflies.registries.EntityTypeRegistry;
import com.bokmcdok.butterflies.registries.ItemRegistry;
import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import com.bokmcdok.butterflies.world.entity.decoration.ButterflyScroll;
import com.bokmcdok.butterflies.world.item.ButterflyContainerItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ButterflyScrollItem
extends Item
implements ButterflyContainerItem {
    private final DataComponentRegistry dataComponentRegistry;
    private final EntityTypeRegistry entityTypeRegistry;
    private final ItemRegistry itemRegistry;
    public static final String NAME = "item.butterflies.butterfly_scroll";
    private final int butterflyIndex;

    public static String getRegistryId(int butterflyIndex) {
        return "butterfly_scroll_" + ButterflySpeciesList.SPECIES[butterflyIndex];
    }

    public ButterflyScrollItem(DataComponentRegistry dataComponentRegistry, EntityTypeRegistry entityTypeRegistry, ItemRegistry itemRegistry, int butterflyIndex) {
        super(new Item.Properties());
        this.dataComponentRegistry = dataComponentRegistry;
        this.entityTypeRegistry = entityTypeRegistry;
        this.itemRegistry = itemRegistry;
        this.butterflyIndex = butterflyIndex;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        this.appendButterflyNameToHoverText(this.dataComponentRegistry, stack, components);
        MutableComponent newComponent = Component.translatable((String)"tooltip.butterflies.scroll");
        Style style = newComponent.getStyle().withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY)).withItalic(Boolean.valueOf(true));
        newComponent.setStyle(style);
        components.add((Component)newComponent);
        super.appendHoverText(stack, context, components, tooltipFlag);
    }

    @Override
    public int getButterflyIndex() {
        return this.butterflyIndex;
    }

    @NotNull
    public Component getName(@NotNull ItemStack itemStack) {
        return Component.translatable((String)NAME);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            int butterflyIndex = this.getButterflyIndex();
            if (butterflyIndex >= 0) {
                this.openScreen(butterflyIndex);
            } else {
                this.replaceWithPaper(player, hand, itemstack);
            }
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null) {
            BlockPos clickedPos = context.getClickedPos();
            Direction clickedFace = context.getClickedFace();
            BlockPos blockPos = clickedPos.relative(clickedFace);
            ItemStack itemInHand = context.getItemInHand();
            if (!this.mayPlace(player, clickedFace, itemInHand, blockPos)) {
                return InteractionResult.FAIL;
            }
            Level level = context.getLevel();
            int butterflyIndex = this.getButterflyIndex();
            if (butterflyIndex >= 0) {
                ButterflyScroll butterflyScroll = new ButterflyScroll(this.entityTypeRegistry, this.itemRegistry, level, blockPos, clickedFace);
                butterflyScroll.setButterflyIndex(butterflyIndex);
                if (butterflyScroll.survives()) {
                    if (!level.isClientSide) {
                        butterflyScroll.playPlacementSound();
                        level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, butterflyScroll.position());
                        level.addFreshEntity((Entity)butterflyScroll);
                    }
                    itemInHand.shrink(1);
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                return InteractionResult.CONSUME;
            }
            this.replaceWithPaper(player, context.getHand(), itemInHand);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useOn(context);
    }

    protected boolean mayPlace(Player player, Direction direction, ItemStack itemStack, BlockPos blockPos) {
        return !direction.getAxis().isVertical() && player.mayUseItemAt(blockPos, direction, itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openScreen(int butterflyIndex) {
        Minecraft.getInstance().setScreen((Screen)new ButterflyScrollScreen(butterflyIndex));
    }

    private void replaceWithPaper(@NotNull Player player, @NotNull InteractionHand hand, ItemStack stack) {
        player.setItemInHand(hand, new ItemStack((ItemLike)Items.PAPER, stack.getCount()));
        player.addItem(new ItemStack((ItemLike)Items.IRON_NUGGET, stack.getCount()));
    }
}

