/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.event;

import com.bokmcdok.butterflies.client.model.ButterflyEggModel;
import com.bokmcdok.butterflies.client.model.ButterflyGolemModel;
import com.bokmcdok.butterflies.client.model.ButterflyModel;
import com.bokmcdok.butterflies.client.model.ButterflyScrollModel;
import com.bokmcdok.butterflies.client.model.CaterpillarModel;
import com.bokmcdok.butterflies.client.model.ChrysalisModel;
import com.bokmcdok.butterflies.client.model.HummingbirdMothModel;
import com.bokmcdok.butterflies.client.renderer.blockentity.ButterflyFeederEntityRenderer;
import com.bokmcdok.butterflies.client.renderer.entity.ButterflyEggRenderer;
import com.bokmcdok.butterflies.client.renderer.entity.ButterflyGolemRenderer;
import com.bokmcdok.butterflies.client.renderer.entity.ButterflyRenderer;
import com.bokmcdok.butterflies.client.renderer.entity.ButterflyScrollRenderer;
import com.bokmcdok.butterflies.client.renderer.entity.CaterpillarRenderer;
import com.bokmcdok.butterflies.client.renderer.entity.ChrysalisRenderer;
import com.bokmcdok.butterflies.client.renderer.entity.GlowButterflyRenderer;
import com.bokmcdok.butterflies.client.renderer.entity.HummingbirdMothRenderer;
import com.bokmcdok.butterflies.registries.BlockEntityTypeRegistry;
import com.bokmcdok.butterflies.registries.EntityTypeRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventListener {
    private final BlockEntityTypeRegistry blockEntityTypeRegistry;
    private final EntityTypeRegistry entityTypeRegistry;

    public ClientEventListener(IEventBus modEventBus, BlockEntityTypeRegistry blockEntityTypeRegistry, EntityTypeRegistry entityTypeRegistry) {
        modEventBus.register((Object)this);
        modEventBus.addListener(this::onRegisterLayerDefinitions);
        modEventBus.addListener(this::onRegisterRenderers);
        this.blockEntityTypeRegistry = blockEntityTypeRegistry;
        this.entityTypeRegistry = entityTypeRegistry;
    }

    @SubscribeEvent
    private void onRegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ButterflyModel.LAYER_LOCATION, ButterflyModel::createBodyLayer);
        event.registerLayerDefinition(CaterpillarModel.LAYER_LOCATION, CaterpillarModel::createBodyLayer);
        event.registerLayerDefinition(ChrysalisModel.LAYER_LOCATION, ChrysalisModel::createBodyLayer);
        event.registerLayerDefinition(ButterflyEggModel.LAYER_LOCATION, ButterflyEggModel::createBodyLayer);
        event.registerLayerDefinition(ButterflyScrollModel.LAYER_LOCATION, ButterflyScrollModel::createBodyLayer);
        event.registerLayerDefinition(ButterflyGolemModel.LAYER_LOCATION, ButterflyGolemModel::createBodyLayer);
        event.registerLayerDefinition(HummingbirdMothModel.LAYER_LOCATION, HummingbirdMothModel::createBodyLayer);
    }

    @SubscribeEvent
    private void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)this.entityTypeRegistry.getButterflyScroll().get(), ButterflyScrollRenderer::new);
        for (DeferredHolder<EntityType<?>, EntityType<? extends Mob>> deferredHolder : this.entityTypeRegistry.getButterflies()) {
            if (deferredHolder.getId().compareTo(ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)"ice")) == 0 || deferredHolder.getId().compareTo(ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)"lava")) == 0 || deferredHolder.getId().compareTo(ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)"light")) == 0) {
                event.registerEntityRenderer((EntityType)deferredHolder.get(), GlowButterflyRenderer::new);
                continue;
            }
            if (deferredHolder.getId().compareTo(ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)"hummingbird")) == 0) {
                event.registerEntityRenderer((EntityType)deferredHolder.get(), HummingbirdMothRenderer::new);
                continue;
            }
            event.registerEntityRenderer((EntityType)deferredHolder.get(), ButterflyRenderer::new);
        }
        for (DeferredHolder<EntityType<?>, EntityType<? extends Mob>> deferredHolder : this.entityTypeRegistry.getCaterpillars()) {
            event.registerEntityRenderer((EntityType)deferredHolder.get(), CaterpillarRenderer::new);
        }
        for (DeferredHolder deferredHolder : this.entityTypeRegistry.getChrysalises()) {
            event.registerEntityRenderer((EntityType)deferredHolder.get(), ChrysalisRenderer::new);
        }
        for (DeferredHolder deferredHolder : this.entityTypeRegistry.getButterflyEggs()) {
            event.registerEntityRenderer((EntityType)deferredHolder.get(), ButterflyEggRenderer::new);
        }
        event.registerEntityRenderer((EntityType)this.entityTypeRegistry.getButterflyGolem().get(), ButterflyGolemRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)this.blockEntityTypeRegistry.getButterflyFeeder().get(), ButterflyFeederEntityRenderer::new);
    }
}

