/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.renderer.entity;

import com.bokmcdok.butterflies.client.model.ButterflyScrollModel;
import com.bokmcdok.butterflies.client.renderer.entity.state.ButterflyScrollRenderState;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.entity.decoration.ButterflyScroll;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ButterflyScrollRenderer
extends EntityRenderer<ButterflyScroll, ButterflyScrollRenderState> {
    private final ButterflyScrollModel model;

    public ButterflyScrollRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new ButterflyScrollModel(context.bakeLayer(ButterflyScrollModel.LAYER_LOCATION));
    }

    @NotNull
    public ButterflyScrollRenderState createRenderState() {
        return new ButterflyScrollRenderState();
    }

    public void extractRenderState(@NotNull ButterflyScroll entity, @NotNull ButterflyScrollRenderState renderState, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)renderState, partialTick);
        renderState.butterflyIndex = entity.getButterflyIndex();
        renderState.direction = entity.getDirection();
    }

    public float getScale() {
        return 0.088f;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ButterflyScrollRenderState renderState) {
        ButterflyData data = ButterflyData.getEntry(renderState.butterflyIndex);
        return data == null ? ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)"textures/gui/butterfly_scroll/admiral.png") : data.getScrollTexture();
    }

    public void render(@NotNull ButterflyScrollRenderState renderState, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffers, int overlay) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees((float)(renderState.direction.get2DDataValue() * -90)));
        poseStack.translate(0.31, -0.31, -0.075);
        float scale = this.getScale();
        poseStack.scale(scale, -scale, -scale);
        RenderType renderType = RenderType.entitySmoothCutout((ResourceLocation)this.getTextureLocation(renderState));
        VertexConsumer vertexConsumer = buffers.getBuffer(renderType);
        this.model.renderToBuffer(poseStack, vertexConsumer, overlay, 0);
        poseStack.popPose();
    }
}

