/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.event.entity;

import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import java.util.Objects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

public class ForgeEntityEventListener {
    public ForgeEntityEventListener(IEventBus forgeEventBus) {
        forgeEventBus.register((Object)this);
    }

    private static boolean isButterflyAttackableByCat(LivingEntity entity, ServerLevel level) {
        if (entity instanceof Butterfly) {
            Butterfly butterfly = (Butterfly)entity;
            return !Objects.equals(butterfly.getData().entityId(), "forester");
        }
        return false;
    }

    @SubscribeEvent
    private void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity = event.getEntity();
        if (entity instanceof Cat) {
            Cat cat = (Cat)entity;
            cat.targetSelector.addGoal(1, (Goal)new NonTameRandomTargetGoal((TamableAnimal)cat, Butterfly.class, false, ForgeEntityEventListener::isButterflyAttackableByCat));
        }
        if ((entity = event.getEntity()) instanceof Fox) {
            Fox fox = (Fox)entity;
            fox.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)fox, Butterfly.class, false));
        }
        if (event.getEntity() instanceof Ocelot || event.getEntity() instanceof Parrot) {
            mob = (Mob)event.getEntity();
            mob.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal(mob, Butterfly.class, false));
        }
        if (event.getEntity() instanceof Spider || event.getEntity() instanceof Witch || event.getEntity() instanceof Zombie) {
            mob = (Mob)event.getEntity();
            mob.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal(mob, Butterfly.class, false));
        }
        if ((entity = event.getEntity()) instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            wolf.targetSelector.addGoal(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)wolf, Butterfly.class, false, null));
        }
    }
}

