/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.event.lifecycle;

import com.bokmcdok.butterflies.client.gui.screens.inventory.ButterflyFeederScreen;
import com.bokmcdok.butterflies.client.gui.screens.inventory.ButterflyMicroscopeScreen;
import com.bokmcdok.butterflies.registries.DecoratedPotPatternsRegistry;
import com.bokmcdok.butterflies.registries.ItemRegistry;
import com.bokmcdok.butterflies.registries.MenuTypeRegistry;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

public class LifecycleEventListener {
    private final DecoratedPotPatternsRegistry decoratedPotPatternsRegistry;
    private final ItemRegistry itemRegistry;
    private final MenuTypeRegistry menuTypeRegistry;

    public LifecycleEventListener(IEventBus modEventBus, DecoratedPotPatternsRegistry decoratedPotPatternsRegistry, ItemRegistry itemRegistry, MenuTypeRegistry menuTypeRegistry) {
        modEventBus.register((Object)this);
        this.decoratedPotPatternsRegistry = decoratedPotPatternsRegistry;
        this.itemRegistry = itemRegistry;
        this.menuTypeRegistry = menuTypeRegistry;
    }

    @SubscribeEvent
    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> this.decoratedPotPatternsRegistry.expandVanillaPatterns(this.itemRegistry));
    }

    @SubscribeEvent
    private void clientSetup(RegisterMenuScreensEvent event) {
        event.register((MenuType)this.menuTypeRegistry.getButterflyFeederMenu().get(), ButterflyFeederScreen::new);
        event.register((MenuType)this.menuTypeRegistry.getButterflyMicroscopeMenu().get(), ButterflyMicroscopeScreen::new);
    }
}

