/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.registries.BlockRegistry;
import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import com.bokmcdok.butterflies.world.entity.ButterflyMobCategory;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.ButterflyEgg;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import com.bokmcdok.butterflies.world.entity.animal.Chrysalis;
import com.bokmcdok.butterflies.world.entity.animal.IceButterfly;
import com.bokmcdok.butterflies.world.entity.animal.LavaMoth;
import com.bokmcdok.butterflies.world.entity.decoration.ButterflyScroll;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class EntityTypeRegistry {
    private final DeferredRegister<EntityType<?>> deferredRegister = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"butterflies");
    private BlockRegistry blockRegistry;
    private DeferredHolder<EntityType<?>, EntityType<ButterflyScroll>> butterflyScroll;
    private List<DeferredHolder<EntityType<?>, EntityType<? extends Mob>>> butterflies;
    private List<DeferredHolder<EntityType<?>, EntityType<? extends Mob>>> caterpillars;
    private List<DeferredHolder<EntityType<?>, EntityType<Chrysalis>>> chrysalises;
    private List<DeferredHolder<EntityType<?>, EntityType<ButterflyEgg>>> butterflyEggs;
    private DeferredHolder<EntityType<?>, EntityType<? extends Mob>> butterflyGolem;

    public EntityTypeRegistry(IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise(BlockRegistry blockRegistry) {
        this.blockRegistry = blockRegistry;
        ResourceKey butterflyScrollKey = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)"butterfly_scroll"));
        this.butterflyScroll = this.deferredRegister.register("butterfly_scroll", () -> EntityType.Builder.of(ButterflyScroll::create, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).build(butterflyScrollKey));
        this.butterflies = new ArrayList<DeferredHolder<EntityType<?>, EntityType<? extends Mob>>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(EntityTypeRegistry.this.registerButterfly(i));
                }
            }
        };
        this.caterpillars = new ArrayList<DeferredHolder<EntityType<?>, EntityType<? extends Mob>>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(EntityTypeRegistry.this.registerCaterpillar(i));
                }
            }
        };
        this.chrysalises = new ArrayList<DeferredHolder<EntityType<?>, EntityType<Chrysalis>>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(EntityTypeRegistry.this.registerChrysalis(i));
                }
            }
        };
        this.butterflyEggs = new ArrayList<DeferredHolder<EntityType<?>, EntityType<ButterflyEgg>>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(EntityTypeRegistry.this.registerButterflyEgg(i));
                }
            }
        };
        this.butterflyGolem = this.registerButterflyGolem();
    }

    public List<DeferredHolder<EntityType<?>, EntityType<? extends Mob>>> getButterflies() {
        return this.butterflies;
    }

    public List<DeferredHolder<EntityType<?>, EntityType<ButterflyEgg>>> getButterflyEggs() {
        return this.butterflyEggs;
    }

    public DeferredHolder<EntityType<?>, EntityType<ButterflyScroll>> getButterflyScroll() {
        return this.butterflyScroll;
    }

    public List<DeferredHolder<EntityType<?>, EntityType<? extends Mob>>> getCaterpillars() {
        return this.caterpillars;
    }

    public List<DeferredHolder<EntityType<?>, EntityType<Chrysalis>>> getChrysalises() {
        return this.chrysalises;
    }

    public DeferredHolder<EntityType<?>, EntityType<? extends Mob>> getButterflyGolem() {
        return this.butterflyGolem;
    }

    private Butterfly createButterfly(EntityType<? extends Butterfly> entityType, Level level) {
        return new Butterfly(this.blockRegistry, entityType, level);
    }

    private Butterfly createIceButterfly(EntityType<? extends Butterfly> entityType, Level level) {
        return new IceButterfly(this.blockRegistry, entityType, level);
    }

    private Butterfly createLavaMoth(EntityType<? extends Butterfly> entityType, Level level) {
        return new LavaMoth(this.blockRegistry, entityType, level);
    }

    private DeferredHolder<EntityType<?>, EntityType<? extends Mob>> registerButterfly(int butterflyIndex) {
        String registryId = Butterfly.getRegistryId(butterflyIndex);
        float width = 0.3f;
        float height = 0.2f;
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)Butterfly.getRegistryId(butterflyIndex)));
        if (registryId.equals("ice")) {
            return this.deferredRegister.register(registryId, () -> EntityType.Builder.of(this::createIceButterfly, (MobCategory)ButterflyMobCategory.BUTTERFLY).sized(width, height).clientTrackingRange(10).build(key));
        }
        if (registryId.equals("lava")) {
            return this.deferredRegister.register(registryId, () -> EntityType.Builder.of(this::createLavaMoth, (MobCategory)ButterflyMobCategory.BUTTERFLY).sized(width, height).clientTrackingRange(10).build(key));
        }
        return this.deferredRegister.register(registryId, () -> EntityType.Builder.of(this::createButterfly, (MobCategory)ButterflyMobCategory.BUTTERFLY).sized(width, height).clientTrackingRange(10).build(key));
    }

    private DeferredHolder<EntityType<?>, EntityType<? extends Mob>> registerCaterpillar(int butterflyIndex) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)Caterpillar.getRegistryId(butterflyIndex)));
        return this.deferredRegister.register(Caterpillar.getRegistryId(butterflyIndex), () -> EntityType.Builder.of(Caterpillar::new, (MobCategory)ButterflyMobCategory.BUTTERFLY).sized(0.1f, 0.1f).build(key));
    }

    private DeferredHolder<EntityType<?>, EntityType<Chrysalis>> registerChrysalis(int butterflyIndex) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)Chrysalis.getRegistryId(butterflyIndex)));
        return this.deferredRegister.register(Chrysalis.getRegistryId(butterflyIndex), () -> EntityType.Builder.of(Chrysalis::new, (MobCategory)ButterflyMobCategory.BUTTERFLY).sized(0.1f, 0.1f).build(key));
    }

    private DeferredHolder<EntityType<?>, EntityType<ButterflyEgg>> registerButterflyEgg(int butterflyIndex) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)ButterflyEgg.getRegistryId(butterflyIndex)));
        return this.deferredRegister.register(ButterflyEgg.getRegistryId(butterflyIndex), () -> EntityType.Builder.of(ButterflyEgg::new, (MobCategory)ButterflyMobCategory.BUTTERFLY).sized(0.1f, 0.1f).build(key));
    }

    private DeferredHolder<EntityType<?>, EntityType<? extends Mob>> registerButterflyGolem() {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)"butterfly_golem"));
        return this.deferredRegister.register("butterfly_golem", () -> EntityType.Builder.of(IronGolem::new, (MobCategory)MobCategory.MISC).sized(1.4f, 2.7f).clientTrackingRange(10).build(key));
    }
}

