/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.registries.BannerPatternRegistry;
import com.bokmcdok.butterflies.registries.BlockRegistry;
import com.bokmcdok.butterflies.registries.DataComponentRegistry;
import com.bokmcdok.butterflies.registries.EntityTypeRegistry;
import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import com.bokmcdok.butterflies.world.item.BottledButterflyItem;
import com.bokmcdok.butterflies.world.item.BottledCaterpillarItem;
import com.bokmcdok.butterflies.world.item.ButterflyBookItem;
import com.bokmcdok.butterflies.world.item.ButterflyEggItem;
import com.bokmcdok.butterflies.world.item.ButterflyNetItem;
import com.bokmcdok.butterflies.world.item.ButterflyScrollItem;
import com.bokmcdok.butterflies.world.item.ButterflyZhuangZiItem;
import com.bokmcdok.butterflies.world.item.CaterpillarItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ItemRegistry {
    private final DeferredRegister<Item> deferredRegister = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"butterflies");
    private BlockRegistry blockRegistry;
    private DataComponentRegistry dataComponentRegistry;
    private EntityTypeRegistry entityTypeRegistry;
    private List<DeferredHolder<Item, Item>> bottledButterflies;
    private List<DeferredHolder<Item, Item>> bottledCaterpillars;
    private DeferredHolder<Item, Item> burntButterflyNet;
    private DeferredHolder<Item, Item> butterflyBannerPattern;
    private DeferredHolder<Item, Item> butterflyBook;
    private List<DeferredHolder<Item, Item>> butterflyEggs;
    private DeferredHolder<Item, Item> butterflyFeeder;
    private DeferredHolder<Item, Item> butterflyMicroscope;
    private List<DeferredHolder<Item, Item>> butterflyNets;
    private DeferredHolder<Item, Item> butterflyPotterySherd;
    private List<DeferredHolder<Item, Item>> butterflyScrolls;
    private DeferredHolder<Item, Item> butterflyGolemSpawnEgg;
    private List<DeferredHolder<Item, Item>> butterflySpawnEggs;
    private List<DeferredHolder<Item, Item>> caterpillars;
    private List<DeferredHolder<Item, Item>> caterpillarSpawnEggs;
    private DeferredHolder<Item, Item> emptyButterflyNet;
    private DeferredHolder<Item, Item> infestedApple;
    private DeferredHolder<Item, Item> silk;
    private DeferredHolder<Item, Item> zhuangziBook;
    private DeferredHolder<Item, Item> butterflyOrigamiBlack;
    private DeferredHolder<Item, Item> butterflyOrigamiBlue;
    private DeferredHolder<Item, Item> butterflyOrigamiBrown;
    private DeferredHolder<Item, Item> butterflyOrigamiCyan;
    private DeferredHolder<Item, Item> butterflyOrigamiGray;
    private DeferredHolder<Item, Item> butterflyOrigamiGreen;
    private DeferredHolder<Item, Item> butterflyOrigamiLightBlue;
    private DeferredHolder<Item, Item> butterflyOrigamiLightGray;
    private DeferredHolder<Item, Item> butterflyOrigamiLime;
    private DeferredHolder<Item, Item> butterflyOrigamiMagenta;
    private DeferredHolder<Item, Item> butterflyOrigamiOrange;
    private DeferredHolder<Item, Item> butterflyOrigamiPink;
    private DeferredHolder<Item, Item> butterflyOrigamiPurple;
    private DeferredHolder<Item, Item> butterflyOrigamiRed;
    private DeferredHolder<Item, Item> butterflyOrigamiWhite;
    private DeferredHolder<Item, Item> butterflyOrigamiYellow;

    public ItemRegistry(IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise(BannerPatternRegistry bannerPatternRegistry, BlockRegistry blockRegistry, DataComponentRegistry dataComponentRegistry, EntityTypeRegistry entityTypeRegistry) {
        this.blockRegistry = blockRegistry;
        this.dataComponentRegistry = dataComponentRegistry;
        this.entityTypeRegistry = entityTypeRegistry;
        this.bottledButterflies = new ArrayList<DeferredHolder<Item, Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerBottledButterfly(i));
                }
            }
        };
        this.bottledCaterpillars = new ArrayList<DeferredHolder<Item, Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerBottledCaterpillar(i));
                }
            }
        };
        this.burntButterflyNet = this.registerItem("butterfly_net_burnt");
        this.butterflyBannerPattern = this.registerBannerPattern(bannerPatternRegistry);
        this.butterflyBook = this.registerButterflyBook();
        this.butterflyEggs = new ArrayList<DeferredHolder<Item, Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerButterflyEgg(i));
                }
            }
        };
        this.butterflyFeeder = this.registerButterflyFeeder();
        this.butterflyMicroscope = this.registerButterflyMicroscope();
        this.butterflyNets = new ArrayList<DeferredHolder<Item, Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerButterflyNet(i));
                }
            }
        };
        this.butterflyOrigamiBlack = this.registerButterflyOrigami("butterfly_origami_black", blockRegistry.getButterflyOrigamiBlack());
        this.butterflyOrigamiBlue = this.registerButterflyOrigami("butterfly_origami_blue", blockRegistry.getButterflyOrigamiBlue());
        this.butterflyOrigamiBrown = this.registerButterflyOrigami("butterfly_origami_brown", blockRegistry.getButterflyOrigamiBrown());
        this.butterflyOrigamiCyan = this.registerButterflyOrigami("butterfly_origami_cyan", blockRegistry.getButterflyOrigamiCyan());
        this.butterflyOrigamiGray = this.registerButterflyOrigami("butterfly_origami_gray", blockRegistry.getButterflyOrigamiGray());
        this.butterflyOrigamiGreen = this.registerButterflyOrigami("butterfly_origami_green", blockRegistry.getButterflyOrigamiGreen());
        this.butterflyOrigamiLightBlue = this.registerButterflyOrigami("butterfly_origami_light_blue", blockRegistry.getButterflyOrigamiLightBlue());
        this.butterflyOrigamiLightGray = this.registerButterflyOrigami("butterfly_origami_light_gray", blockRegistry.getButterflyOrigamiLightGray());
        this.butterflyOrigamiLime = this.registerButterflyOrigami("butterfly_origami_lime", blockRegistry.getButterflyOrigamiLime());
        this.butterflyOrigamiMagenta = this.registerButterflyOrigami("butterfly_origami_magenta", blockRegistry.getButterflyOrigamiMagenta());
        this.butterflyOrigamiOrange = this.registerButterflyOrigami("butterfly_origami_orange", blockRegistry.getButterflyOrigamiOrange());
        this.butterflyOrigamiPink = this.registerButterflyOrigami("butterfly_origami_pink", blockRegistry.getButterflyOrigamiPink());
        this.butterflyOrigamiPurple = this.registerButterflyOrigami("butterfly_origami_purple", blockRegistry.getButterflyOrigamiPurple());
        this.butterflyOrigamiRed = this.registerButterflyOrigami("butterfly_origami_red", blockRegistry.getButterflyOrigamiRed());
        this.butterflyOrigamiWhite = this.registerButterflyOrigami("butterfly_origami_white", blockRegistry.getButterflyOrigamiWhite());
        this.butterflyOrigamiYellow = this.registerButterflyOrigami("butterfly_origami_yellow", blockRegistry.getButterflyOrigamiYellow());
        this.butterflyPotterySherd = this.registerItem("butterfly_pottery_sherd");
        this.butterflyScrolls = new ArrayList<DeferredHolder<Item, Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerButterflyScroll(i));
                }
            }
        };
        this.butterflyGolemSpawnEgg = this.registerSpawnEgg("butterfly_golem", entityTypeRegistry.getButterflyGolem());
        this.butterflySpawnEggs = new ArrayList<DeferredHolder<Item, Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerButterflySpawnEgg(i));
                }
            }
        };
        this.caterpillars = new ArrayList<DeferredHolder<Item, Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerCaterpillar(i));
                }
            }
        };
        this.caterpillarSpawnEggs = new ArrayList<DeferredHolder<Item, Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerCaterpillarSpawnEgg(i));
                }
            }
        };
        this.emptyButterflyNet = this.registerButterflyNet(-1, "butterfly_net");
        this.infestedApple = this.registerItem("infested_apple");
        this.silk = this.registerItem("silk");
        this.zhuangziBook = this.registerZhuangZiBook();
    }

    public List<DeferredHolder<Item, Item>> getBottledButterflies() {
        return this.bottledButterflies;
    }

    public List<DeferredHolder<Item, Item>> getBottledCaterpillars() {
        return this.bottledCaterpillars;
    }

    public DeferredHolder<Item, Item> getButterflyBannerPattern() {
        return this.butterflyBannerPattern;
    }

    public DeferredHolder<Item, Item> getButterflyBook() {
        return this.butterflyBook;
    }

    public DeferredHolder<Item, Item> getButterflyMicroscope() {
        return this.butterflyMicroscope;
    }

    public DeferredHolder<Item, Item> getBurntButterflyNet() {
        return this.burntButterflyNet;
    }

    public List<DeferredHolder<Item, Item>> getButterflyEggs() {
        return this.butterflyEggs;
    }

    public DeferredHolder<Item, Item> getButterflyNetFromIndex(int butterflyIndex) {
        if (butterflyIndex < 0) {
            return this.emptyButterflyNet;
        }
        if (Objects.equals(ButterflySpeciesList.SPECIES[butterflyIndex], "lava")) {
            return this.burntButterflyNet;
        }
        return this.butterflyNets.get(butterflyIndex);
    }

    public DeferredHolder<Item, Item> getButterflyFeeder() {
        return this.butterflyFeeder;
    }

    public List<DeferredHolder<Item, Item>> getButterflyNets() {
        return this.butterflyNets;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiBlack() {
        return this.butterflyOrigamiBlack;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiBlue() {
        return this.butterflyOrigamiBlue;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiBrown() {
        return this.butterflyOrigamiBrown;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiCyan() {
        return this.butterflyOrigamiCyan;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiGray() {
        return this.butterflyOrigamiGray;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiGreen() {
        return this.butterflyOrigamiGreen;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiLightBlue() {
        return this.butterflyOrigamiLightBlue;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiLightGray() {
        return this.butterflyOrigamiLightGray;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiLime() {
        return this.butterflyOrigamiLime;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiMagenta() {
        return this.butterflyOrigamiMagenta;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiOrange() {
        return this.butterflyOrigamiOrange;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiPink() {
        return this.butterflyOrigamiPink;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiPurple() {
        return this.butterflyOrigamiPurple;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiRed() {
        return this.butterflyOrigamiRed;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiWhite() {
        return this.butterflyOrigamiWhite;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiYellow() {
        return this.butterflyOrigamiYellow;
    }

    public DeferredHolder<Item, Item> getButterflyPotterySherd() {
        return this.butterflyPotterySherd;
    }

    public List<DeferredHolder<Item, Item>> getButterflyScrolls() {
        return this.butterflyScrolls;
    }

    public List<DeferredHolder<Item, Item>> getButterflySpawnEggs() {
        return this.butterflySpawnEggs;
    }

    public DeferredHolder<Item, Item> getButterflyGolemSpawnEgg() {
        return this.butterflyGolemSpawnEgg;
    }

    public List<DeferredHolder<Item, Item>> getCaterpillars() {
        return this.caterpillars;
    }

    public List<DeferredHolder<Item, Item>> getCaterpillarSpawnEggs() {
        return this.caterpillarSpawnEggs;
    }

    public DeferredHolder<Item, Item> getEmptyButterflyNet() {
        return this.emptyButterflyNet;
    }

    public DeferredHolder<Item, Item> getInfestedApple() {
        return this.infestedApple;
    }

    public DeferredHolder<Item, Item> getSilk() {
        return this.silk;
    }

    public DeferredHolder<Item, Item> getZhuangziBook() {
        return this.zhuangziBook;
    }

    private ResourceKey<Item> createResourceKey(String registryId) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)registryId);
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)location);
    }

    private DeferredHolder<Item, Item> registerBannerPattern(BannerPatternRegistry bannerPatternRegistry) {
        String registryId = "banner_pattern_butterfly";
        ResourceKey<Item> key = this.createResourceKey("banner_pattern_butterfly");
        return this.deferredRegister.register("banner_pattern_butterfly", () -> new BannerPatternItem(bannerPatternRegistry.getButterflyBannerPatternTagKey(), new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON).setId(key)));
    }

    private DeferredHolder<Item, Item> registerButterflyBook() {
        ResourceKey<Item> key = this.createResourceKey("butterfly_book");
        return this.deferredRegister.register("butterfly_book", () -> new ButterflyBookItem(new Item.Properties().stacksTo(1).setId(key), this.dataComponentRegistry));
    }

    private DeferredHolder<Item, Item> registerButterflyFeeder() {
        String registryId = "butterfly_feeder";
        ResourceKey<Item> key = this.createResourceKey("butterfly_feeder");
        return this.deferredRegister.register("butterfly_feeder", () -> new BlockItem((Block)this.blockRegistry.getButterflyFeeder().get(), new Item.Properties().setId(key)));
    }

    private DeferredHolder<Item, Item> registerButterflyMicroscope() {
        String registryId = "butterfly_microscope";
        ResourceKey<Item> key = this.createResourceKey("butterfly_microscope");
        return this.deferredRegister.register("butterfly_microscope", () -> new BlockItem((Block)this.blockRegistry.getButterflyMicroscope().get(), new Item.Properties().setId(key)));
    }

    private DeferredHolder<Item, Item> registerButterflyNet(int butterflyIndex) {
        return this.registerButterflyNet(butterflyIndex, ButterflyNetItem.getRegistryId(butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerButterflyNet(int butterflyIndex, String registryId) {
        ResourceKey<Item> key = this.createResourceKey(registryId);
        return this.deferredRegister.register(registryId, () -> new ButterflyNetItem(new Item.Properties().stacksTo(1).setId(key), this.dataComponentRegistry, this, butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerBottledButterfly(int butterflyIndex) {
        String registryId = BottledButterflyItem.getRegistryId(butterflyIndex);
        ResourceKey<Item> key = this.createResourceKey(registryId);
        return this.deferredRegister.register(registryId, () -> new BottledButterflyItem(new Item.Properties().stacksTo(1).setId(key), this.dataComponentRegistry, this.blockRegistry.getBottledButterflyBlocks().get(butterflyIndex), butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerBottledCaterpillar(int butterflyIndex) {
        String registryId = BottledCaterpillarItem.getRegistryId(butterflyIndex);
        ResourceKey<Item> key = this.createResourceKey(registryId);
        return this.deferredRegister.register(registryId, () -> new BottledCaterpillarItem(new Item.Properties().stacksTo(1).setId(key), this.blockRegistry.getBottledCaterpillarBlocks().get(butterflyIndex), butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerButterflyEgg(int butterflyIndex) {
        String registryId = ButterflyEggItem.getRegistryId(butterflyIndex);
        ResourceKey<Item> key = this.createResourceKey(registryId);
        return this.deferredRegister.register(registryId, () -> new ButterflyEggItem(butterflyIndex, new Item.Properties().setId(key)));
    }

    private DeferredHolder<Item, Item> registerButterflyOrigami(String registryId, DeferredHolder<Block, Block> block) {
        ResourceKey<Item> key = this.createResourceKey(registryId);
        return this.deferredRegister.register(registryId, () -> new BlockItem((Block)block.get(), new Item.Properties().setId(key)));
    }

    private DeferredHolder<Item, Item> registerButterflyScroll(int butterflyIndex) {
        String registryId = ButterflyScrollItem.getRegistryId(butterflyIndex);
        ResourceKey<Item> key = this.createResourceKey(registryId);
        return this.deferredRegister.register(registryId, () -> new ButterflyScrollItem(new Item.Properties().setId(key), this.dataComponentRegistry, this.entityTypeRegistry, this, butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerButterflySpawnEgg(int butterflyIndex) {
        String registryId = Butterfly.getRegistryId(butterflyIndex);
        return this.registerSpawnEgg(registryId, this.entityTypeRegistry.getButterflies().get(butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerCaterpillar(int butterflyIndex) {
        String registryId = CaterpillarItem.getRegistryId(butterflyIndex);
        ResourceKey<Item> key = this.createResourceKey(registryId);
        return this.deferredRegister.register(registryId, () -> new CaterpillarItem(new Item.Properties().setId(key), Caterpillar.getRegistryId(butterflyIndex)));
    }

    private DeferredHolder<Item, Item> registerCaterpillarSpawnEgg(int butterflyIndex) {
        String registryId = Caterpillar.getRegistryId(butterflyIndex);
        return this.registerSpawnEgg(registryId, this.entityTypeRegistry.getCaterpillars().get(butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerItem(String registryId) {
        return this.registerItem(registryId, new Item.Properties());
    }

    private DeferredHolder<Item, Item> registerItem(String registryId, Item.Properties properties) {
        ResourceKey<Item> key = this.createResourceKey(registryId);
        return this.deferredRegister.register(registryId, () -> new Item(properties.setId(key)));
    }

    private DeferredHolder<Item, Item> registerSpawnEgg(String registryId, DeferredHolder<EntityType<?>, EntityType<? extends Mob>> entityType) {
        ResourceKey<Item> key = this.createResourceKey(registryId);
        return this.deferredRegister.register(registryId, () -> new SpawnEggItem((EntityType)entityType.get(), new Item.Properties().setId(key)));
    }

    private DeferredHolder<Item, Item> registerZhuangZiBook() {
        String registryId = "butterfly_zhuangzi";
        ResourceKey<Item> key = this.createResourceKey(registryId);
        return this.deferredRegister.register(registryId, () -> new ButterflyZhuangZiItem(new Item.Properties().stacksTo(1).setId(key)));
    }
}

