/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.ai;

import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.block.entity.ButterflyFeederEntity;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ButterflyPollinateFlowerGoal
extends MoveToBlockGoal {
    private final Butterfly butterfly;
    private final Block preferredFlowerBlock;
    private final Item preferredFlowerItem;
    public final RandomSource random;
    public boolean attemptedToPollinate;

    public ButterflyPollinateFlowerGoal(Butterfly mob, double speedModifier, int searchRange, int verticalSearchRange) {
        super((PathfinderMob)mob, speedModifier, searchRange, verticalSearchRange);
        this.butterfly = mob;
        ButterflyData data = ButterflyData.getEntry(this.butterfly.getButterflyIndex());
        if (data != null) {
            Optional blockHolder = BuiltInRegistries.BLOCK.get(data.preferredFlower());
            this.preferredFlowerBlock = blockHolder.map(Holder.Reference::value).orElse(null);
            Optional itemHolder = BuiltInRegistries.ITEM.get(data.preferredFlower());
            this.preferredFlowerItem = itemHolder.map(Holder.Reference::value).orElse(null);
        } else {
            this.preferredFlowerBlock = null;
            this.preferredFlowerItem = null;
        }
        this.random = this.butterfly.getRandom();
    }

    public double acceptedDistance() {
        return 2.0;
    }

    public boolean canContinueToUse() {
        return this.butterfly.getIsActive() && super.canContinueToUse();
    }

    public boolean canUse() {
        return this.butterfly.getIsActive() && super.canUse();
    }

    public void start() {
        this.attemptedToPollinate = false;
        super.start();
    }

    public void tick() {
        super.tick();
        if (this.isReachedTarget()) {
            this.tryTicks -= 11;
            Vec3 deltaMovement = this.butterfly.getDeltaMovement();
            this.butterfly.setDeltaMovement(0.0, deltaMovement.y, 0.0);
            if (!this.attemptedToPollinate) {
                BlockState blockState;
                Block budBlock;
                BlockPos spawnPos;
                this.attemptedToPollinate = true;
                BlockEntity blockEntity = this.butterfly.level().getBlockEntity(this.blockPos);
                if (blockEntity instanceof ButterflyFeederEntity) {
                    ButterflyFeederEntity feeder = (ButterflyFeederEntity)blockEntity;
                    if (feeder.getItem(0).is(this.preferredFlowerItem)) {
                        this.butterfly.setNumEggs(1);
                        feeder.removeItem(0, 1);
                    }
                } else if (this.random.nextInt() % 5 == 0 && (spawnPos = this.findNearestFlowerSpot()) != null && (budBlock = this.getFlowerBud((blockState = this.mob.level().getBlockState(this.blockPos)).getBlock())) != null) {
                    this.mob.level().setBlockAndUpdate(spawnPos, budBlock.defaultBlockState());
                }
            }
        }
    }

    @NotNull
    public String toString() {
        return "Pollinate Flower / Target = [" + String.valueOf(this.getMoveToTarget()) + "] / Reached Target = [" + this.isReachedTarget() + "] / Attempted to Pollinate = [" + this.attemptedToPollinate + "] / Num Eggs = [" + this.butterfly.getNumEggs() + "]";
    }

    protected boolean isValidTarget(@NotNull LevelReader levelReader, @NotNull BlockPos blockPos) {
        ButterflyFeederEntity feeder;
        BlockEntity blockEntity;
        if (!levelReader.getBlockState(blockPos.above()).isAir()) {
            return false;
        }
        if (this.butterfly.getNumEggs() == 0 && (blockEntity = levelReader.getBlockEntity(blockPos)) instanceof ButterflyFeederEntity && (feeder = (ButterflyFeederEntity)blockEntity).getItem(0).is(this.preferredFlowerItem)) {
            return true;
        }
        BlockState blockState = levelReader.getBlockState(blockPos);
        if (blockState.is(this.preferredFlowerBlock)) {
            return true;
        }
        if (blockState.is(BlockTags.SMALL_FLOWERS)) {
            return this.random.nextInt() % 2 == 0;
        }
        return false;
    }

    private BlockPos findNearestFlowerSpot() {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int yOffset = this.verticalSearchStart;
        while (yOffset <= 2) {
            for (int range = 0; range < 2; ++range) {
                int xOffset = 0;
                while (xOffset <= range) {
                    int zOffset;
                    int n = zOffset = xOffset < range && xOffset > -range ? range : 0;
                    while (zOffset <= range) {
                        mutableBlockPos.setWithOffset((Vec3i)this.blockPos, xOffset, yOffset - 1, zOffset);
                        Block requiredBlock = Blocks.GRASS_BLOCK;
                        if (this.mob.level().getBlockState(this.blockPos).is(Blocks.TORCHFLOWER)) {
                            requiredBlock = Blocks.FARMLAND;
                        }
                        if (this.mob.level().getBlockState((BlockPos)mutableBlockPos).isAir() && this.mob.level().getBlockState(mutableBlockPos.below()).is(requiredBlock)) {
                            return mutableBlockPos;
                        }
                        zOffset = zOffset > 0 ? -zOffset : 1 - zOffset;
                    }
                    xOffset = xOffset > 0 ? -xOffset : 1 - xOffset;
                }
            }
            yOffset = yOffset > 0 ? -yOffset : 1 - yOffset;
        }
        return null;
    }

    private Block getFlowerBud(Block flowerBlock) {
        if (flowerBlock == Blocks.ALLIUM) {
            return (Block)this.butterfly.getBlockRegistry().getAlliumBud().get();
        }
        if (flowerBlock == Blocks.AZURE_BLUET) {
            return (Block)this.butterfly.getBlockRegistry().getAzureBluetBud().get();
        }
        if (flowerBlock == Blocks.BLUE_ORCHID) {
            return (Block)this.butterfly.getBlockRegistry().getBlueOrchidBud().get();
        }
        if (flowerBlock == Blocks.CORNFLOWER) {
            return (Block)this.butterfly.getBlockRegistry().getCornflowerBud().get();
        }
        if (flowerBlock == Blocks.DANDELION) {
            return (Block)this.butterfly.getBlockRegistry().getDandelionBud().get();
        }
        if (flowerBlock == Blocks.LILY_OF_THE_VALLEY) {
            return (Block)this.butterfly.getBlockRegistry().getLilyOfTheValleyBud().get();
        }
        if (flowerBlock == Blocks.ORANGE_TULIP) {
            return (Block)this.butterfly.getBlockRegistry().getOrangeTulipBud().get();
        }
        if (flowerBlock == Blocks.OXEYE_DAISY) {
            return (Block)this.butterfly.getBlockRegistry().getOxeyeDaisyBud().get();
        }
        if (flowerBlock == Blocks.PINK_TULIP) {
            return (Block)this.butterfly.getBlockRegistry().getPinkTulipBud().get();
        }
        if (flowerBlock == Blocks.POPPY) {
            return (Block)this.butterfly.getBlockRegistry().getPoppyBud().get();
        }
        if (flowerBlock == Blocks.RED_TULIP) {
            return (Block)this.butterfly.getBlockRegistry().getRedTulipBud().get();
        }
        if (flowerBlock == Blocks.TORCHFLOWER) {
            return Blocks.TORCHFLOWER_CROP;
        }
        if (flowerBlock == Blocks.WHITE_TULIP) {
            return (Block)this.butterfly.getBlockRegistry().getWhiteTulipBud().get();
        }
        if (flowerBlock == Blocks.WITHER_ROSE) {
            return (Block)this.butterfly.getBlockRegistry().getWitherRoseBud().get();
        }
        if (flowerBlock == Blocks.SWEET_BERRY_BUSH) {
            return Blocks.SWEET_BERRY_BUSH;
        }
        return null;
    }
}

