/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.animal;

import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import com.bokmcdok.butterflies.world.entity.animal.DirectionalCreature;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;

public class ButterflyEgg
extends DirectionalCreature {
    public static String getRegistryId(int butterflyIndex) {
        return ButterflySpeciesList.SPECIES[butterflyIndex] + "_egg";
    }

    public static void spawn(ServerLevel level, ResourceLocation location, BlockPos spawnBlock, Direction surfaceDirection) {
        Entity entity;
        Optional entityType = BuiltInRegistries.ENTITY_TYPE.get(location);
        if (entityType.isPresent() && (entity = ((EntityType)((Holder.Reference)entityType.get()).value()).create((Level)level, EntitySpawnReason.NATURAL)) instanceof ButterflyEgg) {
            ButterflyEgg egg = (ButterflyEgg)entity;
            double x = (double)spawnBlock.getX() + level.random.nextDouble();
            double y = (double)spawnBlock.getY() + level.random.nextDouble();
            double z = (double)spawnBlock.getZ() + level.random.nextDouble();
            switch (surfaceDirection) {
                case WEST: {
                    x = spawnBlock.getX();
                    break;
                }
                case EAST: {
                    x = (double)spawnBlock.getX() + 1.0;
                    break;
                }
                case DOWN: {
                    y = spawnBlock.getY();
                    break;
                }
                case UP: {
                    y = (double)spawnBlock.getY() + 1.0;
                    break;
                }
                case NORTH: {
                    z = spawnBlock.getZ();
                    break;
                }
                case SOUTH: {
                    z = (double)spawnBlock.getZ() + 1.0;
                }
            }
            egg.moveTo(x, y, z, 0.0f, 0.0f);
            egg.setSurfaceDirection(surfaceDirection);
            egg.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(spawnBlock), EntitySpawnReason.NATURAL, null);
            level.addFreshEntity((Entity)egg);
        }
    }

    public float getRenderScale() {
        return 0.05f * this.getData().getSizeMultiplier();
    }

    public boolean hurtClient(@NotNull DamageSource damageSource) {
        Entity entity = damageSource.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.playSound(SoundEvents.PLAYER_ATTACK_SWEEP, 1.0f, 1.0f);
            return true;
        }
        return super.hurtClient(damageSource);
    }

    public boolean hurtServer(@NotNull ServerLevel level, @NotNull DamageSource damageSource, float damage) {
        Entity entity = damageSource.getEntity();
        if (entity instanceof Player) {
            Optional butterflyEggItem;
            Player player = (Player)entity;
            this.remove(Entity.RemovalReason.DISCARDED);
            ResourceLocation location = this.getData().getButterflyEggItem();
            if (location != null && (butterflyEggItem = BuiltInRegistries.ITEM.get(location)).isPresent()) {
                ItemStack itemStack = new ItemStack((Holder)butterflyEggItem.get());
                player.addItem(itemStack);
            }
            return true;
        }
        return super.hurtServer(level, damageSource, damage);
    }

    public boolean isFood(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public ButterflyEgg(EntityType<? extends ButterflyEgg> entityType, Level level) {
        super(entityType, level);
        String species = ButterflyData.getSpeciesString((LivingEntity)this);
        this.setTexture("textures/item/butterfly_egg/" + species + "_egg.png");
        this.setAge(-this.getData().eggLifespan());
    }

    @Override
    protected void customServerAiStep(@NotNull ServerLevel level) {
        super.customServerAiStep(level);
        if (this.level().isEmptyBlock(this.getSurfaceBlockPos())) {
            this.kill(level);
        }
        if (this.getAge() >= 0 && this.random.nextInt(0, 15) == 0) {
            ResourceLocation newLocation = this.getData().getCaterpillarEntity();
            Caterpillar.spawn((ServerLevel)this.level(), newLocation, this.blockPosition(), this.getDirection(), false);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void doPush(@NotNull Entity otherEntity) {
    }

    @NotNull
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    protected float getSoundVolume() {
        return 0.0f;
    }

    protected void pushEntities() {
    }
}

