/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.decoration;

import com.bokmcdok.butterflies.registries.EntityTypeRegistry;
import com.bokmcdok.butterflies.registries.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButterflyScroll
extends HangingEntity {
    private static final EntityDataAccessor<Integer> BUTTERFLY_INDEX = SynchedEntityData.defineId(ButterflyScroll.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Direction> DATA_DIRECTION = SynchedEntityData.defineId(ButterflyScroll.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private ItemRegistry itemRegistry;
    public static final String NAME = "butterfly_scroll";

    @NotNull
    public static ButterflyScroll create(EntityType<? extends ButterflyScroll> entityType, Level level) {
        return new ButterflyScroll(entityType, level);
    }

    public ButterflyScroll(@NotNull EntityTypeRegistry entityTypeRegistry, @NotNull ItemRegistry itemRegistry, Level level, BlockPos blockPos, Direction direction) {
        this((EntityType<? extends ButterflyScroll>)((EntityType)entityTypeRegistry.getButterflyScroll().get()), level);
        this.itemRegistry = itemRegistry;
        this.pos = blockPos;
        this.setDirection(direction);
    }

    public void dropItem(@NotNull ServerLevel level, @Nullable Entity entity) {
        if (this.itemRegistry != null) {
            ItemStack stack = new ItemStack((ItemLike)this.itemRegistry.getButterflyScrolls().get(this.getButterflyIndex()).get());
            this.spawnAtLocation(level, stack);
        }
    }

    public int getButterflyIndex() {
        return (Integer)this.entityData.get(BUTTERFLY_INDEX);
    }

    public int getHeight() {
        return 14;
    }

    public int getWidth() {
        return 10;
    }

    public void playPlacementSound() {
        this.playSound(SoundEvents.ITEM_FRAME_PLACE, 1.0f, 1.0f);
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        builder.define(BUTTERFLY_INDEX, (Object)0);
        builder.define(DATA_DIRECTION, (Object)Direction.NORTH);
    }

    @NotNull
    protected AABB calculateBoundingBox(@NotNull BlockPos pos, @NotNull Direction direction) {
        direction = this.getDirection();
        double x = (double)this.pos.getX() + 0.5 - (double)direction.getStepX() * 0.46875;
        double y = (double)this.pos.getY() + 0.5 - (double)direction.getStepY() * 0.46875;
        double z = (double)this.pos.getZ() + 0.5 - (double)direction.getStepZ() * 0.46875;
        this.setPosRaw(x, y, z);
        double width = this.getWidth();
        double height = this.getHeight();
        double breadth = this.getWidth();
        Direction.Axis axis = direction.getAxis();
        switch (axis) {
            case X: {
                width = 1.0;
                break;
            }
            case Y: {
                height = 1.0;
                break;
            }
            case Z: {
                breadth = 1.0;
                break;
            }
        }
        return new AABB(x - (width /= 32.0), y - (height /= 32.0), z - (breadth /= 32.0), x + width, y + height, z + breadth);
    }

    public void setButterflyIndex(int index) {
        this.entityData.set(BUTTERFLY_INDEX, (Object)index);
    }

    @NotNull
    public Direction getDirection() {
        return (Direction)this.getEntityData().get(DATA_DIRECTION);
    }

    protected void setDirection(@NotNull Direction direction) {
        this.getEntityData().set(DATA_DIRECTION, (Object)direction);
        this.direction = direction;
        this.setXRot(0.0f);
        this.setYRot(this.direction.get2DDataValue() * 90);
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
    }

    private ButterflyScroll(EntityType<? extends ButterflyScroll> entityType, Level level) {
        super(entityType, level);
    }
}

