/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.registries.BlockRegistry;
import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import com.bokmcdok.butterflies.world.entity.ButterflyMobCategory;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.ButterflyEgg;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import com.bokmcdok.butterflies.world.entity.animal.Chrysalis;
import com.bokmcdok.butterflies.world.entity.animal.IceButterfly;
import com.bokmcdok.butterflies.world.entity.animal.LavaMoth;
import com.bokmcdok.butterflies.world.entity.decoration.ButterflyScroll;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class EntityTypeRegistry {
    private final DeferredRegister<EntityType<?>> deferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"butterflies");
    private BlockRegistry blockRegistry;
    private RegistryObject<EntityType<ButterflyScroll>> butterflyScroll;
    private List<RegistryObject<EntityType<? extends Butterfly>>> butterflies;
    private List<RegistryObject<EntityType<Caterpillar>>> caterpillars;
    private List<RegistryObject<EntityType<Chrysalis>>> chrysalises;
    private List<RegistryObject<EntityType<ButterflyEgg>>> butterflyEggs;
    private RegistryObject<EntityType<IronGolem>> butterflyGolem;

    public EntityTypeRegistry(IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise(BlockRegistry blockRegistry) {
        this.blockRegistry = blockRegistry;
        this.butterflyScroll = this.deferredRegister.register("butterfly_scroll", () -> EntityType.Builder.m_20704_(ButterflyScroll::create, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20712_("butterfly_scroll"));
        this.butterflies = new ArrayList<RegistryObject<EntityType<? extends Butterfly>>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(EntityTypeRegistry.this.registerButterfly(i));
                }
            }
        };
        this.caterpillars = new ArrayList<RegistryObject<EntityType<Caterpillar>>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(EntityTypeRegistry.this.registerCaterpillar(i));
                }
            }
        };
        this.chrysalises = new ArrayList<RegistryObject<EntityType<Chrysalis>>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(EntityTypeRegistry.this.registerChrysalis(i));
                }
            }
        };
        this.butterflyEggs = new ArrayList<RegistryObject<EntityType<ButterflyEgg>>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(EntityTypeRegistry.this.registerButterflyEgg(i));
                }
            }
        };
        this.butterflyGolem = this.registerButterflyGolem();
    }

    public List<RegistryObject<EntityType<? extends Butterfly>>> getButterflies() {
        return this.butterflies;
    }

    public List<RegistryObject<EntityType<ButterflyEgg>>> getButterflyEggs() {
        return this.butterflyEggs;
    }

    public RegistryObject<EntityType<ButterflyScroll>> getButterflyScroll() {
        return this.butterflyScroll;
    }

    public List<RegistryObject<EntityType<Caterpillar>>> getCaterpillars() {
        return this.caterpillars;
    }

    public List<RegistryObject<EntityType<Chrysalis>>> getChrysalises() {
        return this.chrysalises;
    }

    public RegistryObject<EntityType<IronGolem>> getButterflyGolem() {
        return this.butterflyGolem;
    }

    private Butterfly createButterfly(EntityType<? extends Butterfly> entityType, Level level) {
        return new Butterfly(this.blockRegistry, entityType, level);
    }

    private Butterfly createIceButterfly(EntityType<? extends Butterfly> entityType, Level level) {
        return new IceButterfly(this.blockRegistry, entityType, level);
    }

    private Butterfly createLavaMoth(EntityType<? extends Butterfly> entityType, Level level) {
        return new LavaMoth(this.blockRegistry, entityType, level);
    }

    private RegistryObject<EntityType<? extends Butterfly>> registerButterfly(int butterflyIndex) {
        String registryId = Butterfly.getRegistryId(butterflyIndex);
        if (registryId.equals("ice")) {
            return this.deferredRegister.register(registryId, () -> EntityType.Builder.m_20704_(this::createIceButterfly, (MobCategory)ButterflyMobCategory.BUTTERFLY).m_20699_(0.3f, 0.2f).m_20702_(10).m_20712_(Butterfly.getRegistryId(butterflyIndex)));
        }
        if (registryId.equals("lava")) {
            return this.deferredRegister.register(registryId, () -> EntityType.Builder.m_20704_(this::createLavaMoth, (MobCategory)ButterflyMobCategory.BUTTERFLY).m_20699_(0.3f, 0.2f).m_20702_(10).m_20712_(Butterfly.getRegistryId(butterflyIndex)));
        }
        return this.deferredRegister.register(registryId, () -> EntityType.Builder.m_20704_(this::createButterfly, (MobCategory)ButterflyMobCategory.BUTTERFLY).m_20699_(0.3f, 0.2f).m_20702_(10).m_20712_(Butterfly.getRegistryId(butterflyIndex)));
    }

    private RegistryObject<EntityType<Caterpillar>> registerCaterpillar(int butterflyIndex) {
        return this.deferredRegister.register(Caterpillar.getRegistryId(butterflyIndex), () -> EntityType.Builder.m_20704_(Caterpillar::new, (MobCategory)ButterflyMobCategory.BUTTERFLY).m_20699_(0.1f, 0.1f).m_20712_(Caterpillar.getRegistryId(butterflyIndex)));
    }

    private RegistryObject<EntityType<Chrysalis>> registerChrysalis(int butterflyIndex) {
        return this.deferredRegister.register(Chrysalis.getRegistryId(butterflyIndex), () -> EntityType.Builder.m_20704_(Chrysalis::new, (MobCategory)ButterflyMobCategory.BUTTERFLY).m_20699_(0.1f, 0.1f).m_20712_(Chrysalis.getRegistryId(butterflyIndex)));
    }

    private RegistryObject<EntityType<ButterflyEgg>> registerButterflyEgg(int butterflyIndex) {
        return this.deferredRegister.register(ButterflyEgg.getRegistryId(butterflyIndex), () -> EntityType.Builder.m_20704_(ButterflyEgg::new, (MobCategory)ButterflyMobCategory.BUTTERFLY).m_20699_(0.1f, 0.1f).m_20712_(ButterflyEgg.getRegistryId(butterflyIndex)));
    }

    private RegistryObject<EntityType<IronGolem>> registerButterflyGolem() {
        return this.deferredRegister.register("butterfly_golem", () -> EntityType.Builder.m_20704_(IronGolem::new, (MobCategory)MobCategory.MISC).m_20699_(1.4f, 2.7f).m_20702_(10).m_20712_("butterfly_golem"));
    }
}

