/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.world.inventory.ButterflyFeederMenu;
import com.bokmcdok.butterflies.world.inventory.ButterflyMicroscopeMenu;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class MenuTypeRegistry {
    private final DeferredRegister<MenuType<?>> deferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"butterflies");
    private RegistryObject<MenuType<ButterflyFeederMenu>> butterflyFeederMenu;
    private RegistryObject<MenuType<ButterflyMicroscopeMenu>> butterflyMicroscopeMenu;

    public MenuTypeRegistry(IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise() {
        this.butterflyFeederMenu = this.deferredRegister.register("butterfly_feeder", () -> new MenuType(this::createButterflyFeederMenu));
        this.butterflyMicroscopeMenu = this.deferredRegister.register("butterfly_microscope", () -> new MenuType(this::createButterflyMicroscopeMenu));
    }

    public RegistryObject<MenuType<ButterflyFeederMenu>> getButterflyFeederMenu() {
        return this.butterflyFeederMenu;
    }

    public RegistryObject<MenuType<ButterflyMicroscopeMenu>> getButterflyMicroscopeMenu() {
        return this.butterflyMicroscopeMenu;
    }

    private ButterflyFeederMenu createButterflyFeederMenu(int containerId, Inventory playerInventory) {
        return new ButterflyFeederMenu((MenuType)this.butterflyFeederMenu.get(), containerId, playerInventory);
    }

    private ButterflyMicroscopeMenu createButterflyMicroscopeMenu(int containerId, Inventory playerInventory) {
        return new ButterflyMicroscopeMenu((MenuType)this.butterflyMicroscopeMenu.get(), containerId, playerInventory);
    }
}

