/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.ai;

import com.bokmcdok.butterflies.config.ButterfliesConfig;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.ButterflyEgg;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ButterflyLayEggGoal
extends MoveToBlockGoal {
    private final Butterfly butterfly;

    public ButterflyLayEggGoal(Butterfly mob, double speedModifier, int searchRange, int verticalSearchRange) {
        super((PathfinderMob)mob, speedModifier, searchRange, verticalSearchRange);
        this.butterfly = mob;
    }

    public boolean m_8045_() {
        return this.butterfly.getIsActive() && super.m_8045_();
    }

    public boolean m_8036_() {
        return this.butterfly.getIsActive() && this.butterfly.getIsFertile() && super.m_8036_();
    }

    public void m_8056_() {
        super.m_8056_();
    }

    public void m_8041_() {
        this.butterfly.setLanded(false);
        super.m_8041_();
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.m_25625_()) {
            this.f_25601_ -= 11;
            Vec3 deltaMovement = this.butterfly.m_20184_();
            this.butterfly.setLanded(true);
            this.butterfly.m_20334_(0.0, deltaMovement.f_82480_, 0.0);
            if (this.butterfly.getIsFertile()) {
                List numButterflies = this.butterfly.f_19853_.m_45971_(Butterfly.class, TargetingConditions.m_148353_(), (LivingEntity)this.butterfly, this.butterfly.m_142469_().m_82400_(32.0));
                int maxDensity = (Integer)ButterfliesConfig.maxDensity.get();
                if (maxDensity == 0 || numButterflies.size() <= maxDensity) {
                    Direction direction;
                    switch (this.butterfly.m_21187_().nextInt(6)) {
                        default: {
                            Direction direction2 = Direction.UP;
                            break;
                        }
                        case 1: {
                            Direction direction2 = Direction.DOWN;
                            break;
                        }
                        case 2: {
                            Direction direction2 = Direction.NORTH;
                            break;
                        }
                        case 3: {
                            Direction direction2 = Direction.EAST;
                            break;
                        }
                        case 4: {
                            Direction direction2 = Direction.SOUTH;
                            break;
                        }
                        case 5: {
                            Direction direction2 = direction = Direction.WEST;
                        }
                    }
                    if (this.butterfly.f_19853_.m_8055_(this.f_25602_.m_142300_(direction)).m_60795_()) {
                        ResourceLocation eggEntity = this.butterfly.getData().getButterflyEggEntity();
                        ButterflyEgg.spawn((ServerLevel)this.butterfly.f_19853_, eggEntity, this.f_25602_, direction);
                        this.butterfly.setIsFertile(false);
                        this.butterfly.useEgg();
                    }
                }
            }
        } else {
            this.f_25601_ += 11;
        }
    }

    @NotNull
    public String toString() {
        return "Lay Egg / Target = [" + this.m_6669_() + "] / Reached Target = [" + this.m_25625_() + "] / Landed = [" + this.butterfly.getIsLanded() + "] / Fertile = [" + this.butterfly.getIsFertile() + "] / Num Eggs = [" + this.butterfly.getNumEggs() + "]";
    }

    protected boolean m_6465_(@NotNull LevelReader levelReader, @NotNull BlockPos blockPos) {
        if (!levelReader.m_46859_(blockPos.m_7494_())) {
            return false;
        }
        if (this.butterfly.isValidLandingBlock(levelReader.m_8055_(blockPos))) {
            return blockPos.m_123342_() < this.butterfly.m_146904_();
        }
        return false;
    }
}

