/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.animal;

import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import com.bokmcdok.butterflies.world.entity.DebugInfoSupplier;
import com.bokmcdok.butterflies.world.entity.animal.Chrysalis;
import com.bokmcdok.butterflies.world.entity.animal.DirectionalCreature;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class Caterpillar
extends DirectionalCreature
implements DebugInfoSupplier {
    protected static final EntityDataAccessor<Boolean> DATA_IS_BOTTLED = SynchedEntityData.m_135353_(Caterpillar.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final String IS_BOTTLED = "is_bottled";
    private static final double CATERPILLAR_SPEED = 0.00325;
    @Nullable
    private Vec3 targetPosition;
    private boolean isNoGravity = true;

    public static String getRegistryId(int butterflyIndex) {
        return ButterflySpeciesList.SPECIES[butterflyIndex] + "_caterpillar";
    }

    public static void spawn(ServerLevel level, ResourceLocation location, BlockPos position, Direction direction, boolean isBottled) {
        Entity entity;
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(location);
        if (entityType != null && (entity = entityType.m_20615_((Level)level)) instanceof Caterpillar) {
            Caterpillar caterpillar = (Caterpillar)entity;
            caterpillar.setIsBottled(isBottled);
            double x = (double)position.m_123341_() + 0.45;
            double y = (double)position.m_123342_() + 0.4;
            double z = (double)position.m_123343_() + 0.5;
            if (isBottled) {
                direction = Direction.DOWN;
                y = (double)position.m_123342_() + 0.07;
                caterpillar.m_20331_(true);
                caterpillar.m_21530_();
            } else {
                switch (direction) {
                    case DOWN: {
                        y = position.m_123342_();
                        break;
                    }
                    case UP: {
                        y = (double)position.m_123342_() + 1.0;
                        break;
                    }
                    case NORTH: {
                        z = position.m_123343_();
                        break;
                    }
                    case SOUTH: {
                        z = (double)position.m_123343_() + 1.0;
                        break;
                    }
                    case WEST: {
                        x = position.m_123341_();
                        break;
                    }
                    case EAST: {
                        x = (double)position.m_123341_() + 1.0;
                    }
                }
            }
            caterpillar.m_7678_(x, y, z, 0.0f, 0.0f);
            caterpillar.setSurfaceDirection(direction);
            caterpillar.m_6518_((ServerLevelAccessor)level, level.m_6436_(position), MobSpawnType.NATURAL, null, null);
            level.m_7967_((Entity)caterpillar);
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_(IS_BOTTLED, ((Boolean)this.f_19804_.m_135370_(DATA_IS_BOTTLED)).booleanValue());
    }

    public float getRenderScale() {
        float scale = (float)this.m_146764_() / -24000.0f;
        scale *= 0.04f;
        return (scale += 0.08f) * this.getData().getSizeMultiplier();
    }

    public boolean m_6469_(@NotNull DamageSource damageSource, float damage) {
        Entity entity = damageSource.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.m_183503_().f_46443_) {
                player.m_5496_(SoundEvents.f_12317_, 1.0f, 1.0f);
            } else {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                Item caterpillarItem = (Item)ForgeRegistries.ITEMS.getValue(this.getData().getCaterpillarItem());
                if (caterpillarItem != null) {
                    ItemStack itemStack = new ItemStack((ItemLike)caterpillarItem);
                    player.m_36356_(itemStack);
                }
            }
            return true;
        }
        return super.m_6469_(damageSource, damage);
    }

    public boolean m_6898_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean m_6090_() {
        return true;
    }

    public boolean m_20068_() {
        return this.isNoGravity;
    }

    public boolean m_6094_() {
        return false;
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_(IS_BOTTLED)) {
            this.f_19804_.m_135381_(DATA_IS_BOTTLED, (Object)tag.m_128471_(IS_BOTTLED));
        }
    }

    public void m_146762_(int age) {
        this.f_146733_ = age;
    }

    public boolean m_6783_(double distance) {
        double d0 = this.m_142469_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 *= 64.0 * Caterpillar.m_20150_()) * d0;
    }

    public Caterpillar(EntityType<? extends Caterpillar> entityType, Level level) {
        super(entityType, level);
        this.setTexture("textures/entity/caterpillar/caterpillar_" + ButterflyData.getSpeciesString((LivingEntity)this) + ".png");
        this.m_146762_(-this.getData().caterpillarLifespan());
    }

    public void m_6034_(double x, double y, double z) {
        if (this.m_20185_() == 0.0 && this.m_20186_() == 0.0 && this.m_20189_() == 0.0) {
            super.m_6034_(x, y, z);
        }
        if (Mth.m_14107_((double)x) == this.m_142538_().m_123341_() && Mth.m_14107_((double)y) == this.m_142538_().m_123342_() && Mth.m_14107_((double)z) == this.m_142538_().m_123343_()) {
            super.m_6034_(x, y, z);
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        this.isNoGravity = true;
        if (this.getIsReleased()) {
            BlockPos surfaceBlockPos = this.getSurfaceBlockPos();
            if (this.m_183503_().m_46805_(surfaceBlockPos)) {
                if (this.m_183503_().m_46859_(surfaceBlockPos)) {
                    this.setSurfaceDirection(Direction.DOWN);
                }
                if (this.getSurfaceDirection() == Direction.DOWN && (this.m_183503_().m_46859_(surfaceBlockPos) || this.m_20182_().m_7098_() - (double)this.m_142538_().m_123342_() > 0.01)) {
                    this.targetPosition = null;
                    this.isNoGravity = false;
                }
            }
        }
        if (this.m_20068_()) {
            Direction direction = this.getSurfaceDirection();
            Direction.Axis axis = direction.m_122434_();
            if (this.targetPosition == null || this.targetPosition.m_82557_(this.m_20182_()) < 0.007 || this.f_19796_.nextInt(30) == 0) {
                if (this.targetPosition == null) {
                    this.targetPosition = this.m_20182_();
                }
                this.targetPosition = axis == Direction.Axis.X ? new Vec3(this.targetPosition.m_7096_(), Math.floor(this.targetPosition.m_7098_()) + this.clampedRandomDouble(), Math.floor(this.targetPosition.m_7094_()) + this.clampedRandomDouble()) : (axis == Direction.Axis.Y ? new Vec3(Math.floor(this.targetPosition.m_7096_()) + this.clampedRandomDouble(), this.targetPosition.m_7098_(), Math.floor(this.targetPosition.m_7094_()) + this.clampedRandomDouble()) : new Vec3(Math.floor(this.targetPosition.m_7096_()) + this.clampedRandomDouble(), Math.floor(this.targetPosition.m_7098_()) + this.clampedRandomDouble(), this.targetPosition.m_7094_()));
            }
            Vec3 updatedDeltaMovement = this.getUpdatedDeltaMovement(axis);
            this.m_20256_(updatedDeltaMovement);
            this.f_20902_ = 0.5f;
            double rotationDelta = this.getRotationDelta(direction, updatedDeltaMovement);
            this.m_146922_(this.m_146908_() + (float)rotationDelta);
            if (this.getIsReleased() && this.m_146764_() >= 0 && this.f_19796_.nextInt(0, 15) == 0) {
                BlockPos surfaceBlockPos = this.getSurfaceBlockPos();
                if (this.getData().isValidLandingBlock(this.m_183503_().m_8055_(surfaceBlockPos))) {
                    ResourceLocation newLocation = this.getData().getChrysalisEntity();
                    Chrysalis.spawn((ServerLevel)this.m_183503_(), newLocation, this.getSurfaceBlockPos(), this.getSurfaceDirection(), this.m_20182_(), this.m_146908_());
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                } else {
                    this.m_6469_(DamageSource.f_19313_, 1.0f);
                }
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_BOTTLED, (Object)false);
    }

    protected void m_7324_(@NotNull Entity otherEntity) {
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.getData().caterpillarSounds()) {
            return new SoundEvent(new ResourceLocation("butterflies", ButterflyData.getSpeciesString((LivingEntity)this)));
        }
        return super.m_7515_();
    }

    @Override
    public String getDebugInfo() {
        return "Position = [" + String.format("%.3f", this.m_20185_() % 1.0) + ", " + String.format("%.3f", this.m_20186_() % 1.0) + ", " + String.format("%.3f", this.m_20189_() % 1.0) + "] / BlockPos = [" + this.m_142538_() + "] / SurfaceBlock = [" + this.getSurfaceBlockPos() + "] / SurfaceDirection = [" + this.getSurfaceDirection().m_122433_() + "] / IsNoGravity = [" + this.isNoGravity + "]";
    }

    @Override
    protected boolean getIsReleased() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_BOTTLED) == false;
    }

    @NotNull
    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    @NotNull
    protected AABB m_142242_() {
        AABB boundingBox = super.m_142242_();
        return boundingBox.m_82400_(0.05);
    }

    protected void m_6138_() {
    }

    private double clampedDouble(double x) {
        return Math.max(0.05, Math.min(0.95, x));
    }

    private double clampedRandomDouble() {
        return this.clampedDouble(this.f_19796_.nextDouble() % 1.0);
    }

    private double getRotationDelta(Direction direction, Vec3 updatedDeltaMovement) {
        double updatedRotation = direction == Direction.DOWN ? Mth.m_14136_((double)updatedDeltaMovement.f_82481_, (double)updatedDeltaMovement.f_82479_) * 57.29577951308232 - 90.0 : (direction == Direction.UP ? Mth.m_14136_((double)updatedDeltaMovement.f_82479_, (double)updatedDeltaMovement.f_82481_) * 57.29577951308232 - 180.0 : (direction == Direction.NORTH ? Mth.m_14136_((double)updatedDeltaMovement.f_82479_, (double)updatedDeltaMovement.f_82480_) * 57.29577951308232 - 180.0 : (direction == Direction.SOUTH ? Mth.m_14136_((double)updatedDeltaMovement.f_82480_, (double)updatedDeltaMovement.f_82479_) * 57.29577951308232 - 90.0 : (direction == Direction.EAST ? Mth.m_14136_((double)updatedDeltaMovement.f_82481_, (double)updatedDeltaMovement.f_82480_) * 57.29577951308232 - 90.0 : Mth.m_14136_((double)updatedDeltaMovement.f_82480_, (double)updatedDeltaMovement.f_82481_) * 57.29577951308232))));
        return Mth.m_14175_((double)(updatedRotation - (double)this.m_146908_()));
    }

    @NotNull
    private Vec3 getUpdatedDeltaMovement(Direction.Axis axis) {
        Vec3 updatedDeltaMovement = Vec3.f_82478_;
        if (this.targetPosition != null) {
            Vec3 updatedMovementDelta = this.targetPosition.m_82546_(this.m_20182_()).m_82520_(0.1, 0.1, 0.1);
            double signumX = Math.signum(updatedMovementDelta.f_82479_);
            double signumY = Math.signum(updatedMovementDelta.f_82480_);
            double signumZ = Math.signum(updatedMovementDelta.f_82481_);
            Vec3 deltaMovement = this.m_20184_();
            double xMod = 0.0;
            double yMod = 0.0;
            double zMod = 0.0;
            if (axis == Direction.Axis.X) {
                yMod = (signumY * 0.5 - deltaMovement.f_82480_) * 0.00325;
                zMod = (signumZ * 0.5 - deltaMovement.f_82481_) * 0.00325;
            } else if (axis == Direction.Axis.Y) {
                xMod = (signumX * 0.5 - deltaMovement.f_82479_) * 0.00325;
                zMod = (signumZ * 0.5 - deltaMovement.f_82481_) * 0.00325;
            } else {
                xMod = (signumX * 0.5 - deltaMovement.f_82479_) * 0.00325;
                yMod = (signumY * 0.5 - deltaMovement.f_82480_) * 0.00325;
            }
            updatedDeltaMovement = deltaMovement.m_82520_(xMod, yMod, zMod);
            if (this.m_20185_() % 1.0 > 0.95 || this.m_20185_() < 0.05) {
                updatedDeltaMovement.m_82542_(0.0, 1.0, 1.0);
            }
            if (this.m_20186_() % 1.0 > 0.95 || this.m_20186_() < 0.05) {
                updatedDeltaMovement.m_82542_(1.0, 0.0, 1.0);
            }
            if (this.m_20189_() % 1.0 > 0.95 || this.m_20189_() < 0.05) {
                updatedDeltaMovement.m_82542_(1.0, 1.0, 0.0);
            }
        }
        return updatedDeltaMovement;
    }

    private void setIsBottled(boolean isBottled) {
        this.f_19804_.m_135381_(DATA_IS_BOTTLED, (Object)isBottled);
    }
}

