/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.animal;

import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.DirectionalCreature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class Chrysalis
extends DirectionalCreature {
    public static String getRegistryId(int butterflyIndex) {
        return ButterflySpeciesList.SPECIES[butterflyIndex] + "_chrysalis";
    }

    public static void spawn(ServerLevel level, ResourceLocation location, BlockPos spawnBlock, Direction surfaceDirection, Vec3 position, float yRotation) {
        Entity entity;
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(location);
        if (entityType != null && (entity = entityType.m_20615_((Level)level)) instanceof Chrysalis) {
            Chrysalis chrysalis = (Chrysalis)entity;
            chrysalis.m_7678_(position.f_82479_, position.f_82480_, position.f_82481_, 0.0f, 0.0f);
            chrysalis.m_146922_(yRotation);
            chrysalis.setSurfaceDirection(surfaceDirection);
            chrysalis.m_6518_((ServerLevelAccessor)level, level.m_6436_(spawnBlock), MobSpawnType.NATURAL, null, null);
            level.m_7967_((Entity)chrysalis);
        }
    }

    public float getRenderScale() {
        float scale = (float)this.m_146764_() / -24000.0f;
        scale *= 0.06f;
        return (scale += 0.1f) * this.getData().getSizeMultiplier();
    }

    public boolean m_6898_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean m_6090_() {
        return true;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_146762_(int age) {
        this.f_146733_ = age;
    }

    public boolean m_6783_(double distance) {
        double d0 = this.m_142469_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 *= 64.0 * Chrysalis.m_20150_()) * d0;
    }

    public Chrysalis(EntityType<? extends Chrysalis> entityType, Level level) {
        super(entityType, level);
        String[] split;
        String species = "undiscovered";
        String encodeId = this.m_20078_();
        if (encodeId != null && (split = encodeId.split(":")).length >= 2 && (split = (species = split[1]).split("_")).length >= 2) {
            species = split[0];
        }
        this.setTexture("textures/entity/chrysalis/chrysalis_" + species + ".png");
        this.m_146762_(-this.getData().chrysalisLifespan());
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.m_183503_().m_46859_(this.getSurfaceBlockPos())) {
            this.m_6074_();
        }
        if (this.m_146764_() >= 0 && this.f_19796_.nextInt(0, 15) == 0) {
            ResourceLocation newLocation = this.getData().getMateButterflyEntity(this.f_19796_);
            Butterfly.spawn(this.m_183503_(), newLocation, this.m_142538_(), false);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_7324_(@NotNull Entity otherEntity) {
    }

    @NotNull
    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected float m_6121_() {
        return 0.0f;
    }

    protected void m_6138_() {
    }
}

