/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.animal;

import com.bokmcdok.butterflies.world.ButterflyData;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class DirectionalCreature
extends Animal {
    protected static final EntityDataAccessor<Direction> DATA_DIRECTION = SynchedEntityData.m_135353_(DirectionalCreature.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    protected static final String DIRECTION = "direction";
    private ButterflyData data = null;
    private ResourceLocation texture;

    public static boolean checkDirectionalSpawnRules(EntityType<? extends Mob> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos blockPos, Random random) {
        String descriptionId = entityType.m_20675_();
        String[] components = descriptionId.split("\\.");
        for (Direction direction : Direction.values()) {
            BlockPos surfacePosition = blockPos;
            if (direction.m_122421_() == Direction.AxisDirection.NEGATIVE) {
                surfacePosition = surfacePosition.m_142300_(direction);
            }
            if (!level.m_46805_(surfacePosition)) continue;
            ButterflyData data = ButterflyData.getEntry(new ResourceLocation("butterflies", components[2]));
            if (data == null) {
                return level.m_8055_(surfacePosition).m_204336_(BlockTags.f_13035_);
            }
            if (!data.isValidLandingBlock(level.m_8055_(surfacePosition))) continue;
            return true;
        }
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0);
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_(DIRECTION, ((Direction)this.f_19804_.m_135370_(DATA_DIRECTION)).m_122433_());
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor levelAccessor, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag compoundTag) {
        if (spawnType == MobSpawnType.SPAWN_EGG) {
            this.m_21530_();
        }
        if (!levelAccessor.m_46805_(this.getSurfaceBlockPos())) {
            this.setSurfaceDirection(Direction.DOWN);
        }
        if (this.getIsReleased() && levelAccessor.m_46805_(this.getSurfaceBlockPos()) && !this.getData().isValidLandingBlock(levelAccessor.m_8055_(this.getSurfaceBlockPos()))) {
            for (Direction direction : Direction.values()) {
                BlockPos surfacePosition = this.m_142538_().m_142300_(direction);
                if (!levelAccessor.m_46805_(surfacePosition) || !this.getData().isValidLandingBlock(levelAccessor.m_8055_(surfacePosition))) continue;
                this.setSurfaceDirection(direction);
                Vec3 position = this.m_20182_();
                double x = position.m_7096_();
                double y = position.m_7098_();
                double z = position.m_7094_();
                switch (direction) {
                    case DOWN: {
                        y = Math.floor(position.m_7098_());
                        break;
                    }
                    case UP: {
                        y = Math.floor(position.m_7098_()) + 1.0;
                        break;
                    }
                    case NORTH: {
                        z = Math.floor(position.m_7094_());
                        break;
                    }
                    case SOUTH: {
                        z = Math.floor(position.m_7094_()) + 1.0;
                        break;
                    }
                    case WEST: {
                        x = Math.floor(position.m_7096_());
                        break;
                    }
                    case EAST: {
                        x = Math.floor(position.m_7096_()) + 1.0;
                    }
                }
                this.m_7678_(x, y, z, 0.0f, 0.0f);
                break;
            }
        }
        return super.m_6518_(levelAccessor, difficulty, spawnType, groupData, compoundTag);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob mob) {
        return null;
    }

    @NotNull
    public Direction getSurfaceDirection() {
        return (Direction)this.f_19804_.m_135370_(DATA_DIRECTION);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        String name;
        Direction direction;
        super.m_7378_(tag);
        if (tag.m_128441_(DIRECTION) && (direction = Direction.m_122402_((String)(name = tag.m_128461_(DIRECTION)))) != null) {
            this.f_19804_.m_135381_(DATA_DIRECTION, (Object)direction);
        }
    }

    public void setSurfaceDirection(Direction direction) {
        this.f_19804_.m_135381_(DATA_DIRECTION, (Object)direction);
    }

    protected void m_8024_() {
        super.m_8024_();
        this.m_146762_(this.m_146764_() + 1);
    }

    protected DirectionalCreature(EntityType<? extends DirectionalCreature> entityType, Level level) {
        super(entityType, level);
    }

    protected void setTexture(String texture) {
        this.texture = new ResourceLocation("butterflies", texture);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_DIRECTION, (Object)Direction.DOWN);
    }

    protected ButterflyData getData() {
        if (this.data == null) {
            this.data = ButterflyData.getButterflyDataForEntity((LivingEntity)this);
        }
        return this.data;
    }

    protected boolean getIsReleased() {
        return true;
    }

    protected BlockPos getSurfaceBlockPos() {
        return switch (this.getSurfaceDirection().m_122421_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.AxisDirection.POSITIVE -> this.m_142538_();
            case Direction.AxisDirection.NEGATIVE -> this.m_142538_().m_142300_(this.getSurfaceDirection());
        };
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }
}

