/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.event;

import com.bokmcdok.butterflies.client.model.ButterflyEggModel;
import com.bokmcdok.butterflies.client.model.ButterflyGolemModel;
import com.bokmcdok.butterflies.client.model.ButterflyModel;
import com.bokmcdok.butterflies.client.model.ButterflyScrollModel;
import com.bokmcdok.butterflies.client.model.CaterpillarModel;
import com.bokmcdok.butterflies.client.model.ChrysalisModel;
import com.bokmcdok.butterflies.client.model.HummingbirdMothModel;
import com.bokmcdok.butterflies.client.renderer.blockentity.ButterflyFeederEntityRenderer;
import com.bokmcdok.butterflies.client.renderer.entity.ButterflyEggRenderer;
import com.bokmcdok.butterflies.client.renderer.entity.ButterflyGolemRenderer;
import com.bokmcdok.butterflies.client.renderer.entity.ButterflyRenderer;
import com.bokmcdok.butterflies.client.renderer.entity.ButterflyScrollRenderer;
import com.bokmcdok.butterflies.client.renderer.entity.CaterpillarRenderer;
import com.bokmcdok.butterflies.client.renderer.entity.ChrysalisRenderer;
import com.bokmcdok.butterflies.client.renderer.entity.GlowButterflyRenderer;
import com.bokmcdok.butterflies.client.renderer.entity.HummingbirdMothRenderer;
import com.bokmcdok.butterflies.registries.BlockEntityTypeRegistry;
import com.bokmcdok.butterflies.registries.EntityTypeRegistry;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.ButterflyEgg;
import com.bokmcdok.butterflies.world.entity.decoration.ButterflyScroll;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventListener {
    private final BlockEntityTypeRegistry blockEntityTypeRegistry;
    private final EntityTypeRegistry entityTypeRegistry;

    public ClientEventListener(IEventBus modEventBus, BlockEntityTypeRegistry blockEntityTypeRegistry, EntityTypeRegistry entityTypeRegistry) {
        modEventBus.register((Object)this);
        modEventBus.addListener(this::onRegisterLayerDefinitions);
        modEventBus.addListener(this::onRegisterRenderers);
        this.blockEntityTypeRegistry = blockEntityTypeRegistry;
        this.entityTypeRegistry = entityTypeRegistry;
    }

    public void onRegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ButterflyModel.LAYER_LOCATION, ButterflyModel::createBodyLayer);
        event.registerLayerDefinition(CaterpillarModel.LAYER_LOCATION, CaterpillarModel::createBodyLayer);
        event.registerLayerDefinition(ChrysalisModel.LAYER_LOCATION, ChrysalisModel::createBodyLayer);
        event.registerLayerDefinition(ButterflyEggModel.LAYER_LOCATION, ButterflyEggModel::createBodyLayer);
        event.registerLayerDefinition(ButterflyScrollModel.LAYER_LOCATION, ButterflyScrollModel::createBodyLayer);
        event.registerLayerDefinition(ButterflyGolemModel.LAYER_LOCATION, ButterflyGolemModel::m_170698_);
        event.registerLayerDefinition(HummingbirdMothModel.LAYER_LOCATION, HummingbirdMothModel::createBodyLayer);
    }

    private void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        List<RegistryObject<EntityType<? extends Butterfly>>> butterflies = this.entityTypeRegistry.getButterflies();
        for (int i = 0; i < butterflies.size(); ++i) {
            EntityRendererProvider<Butterfly> rendererProvider = ClientEventListener.getButterflyEntityRendererProvider(i);
            event.registerEntityRenderer((EntityType)butterflies.get(i).get(), rendererProvider);
        }
        for (RegistryObject<EntityType<ButterflyEgg>> i : this.entityTypeRegistry.getButterflyEggs()) {
            event.registerEntityRenderer((EntityType)i.get(), ButterflyEggRenderer::new);
        }
        event.registerBlockEntityRenderer((BlockEntityType)this.blockEntityTypeRegistry.getButterflyFeeder().get(), ButterflyFeederEntityRenderer::new);
        event.registerEntityRenderer((EntityType)this.entityTypeRegistry.getButterflyGolem().get(), ButterflyGolemRenderer::new);
        event.registerEntityRenderer((EntityType)this.entityTypeRegistry.getButterflyScroll().get(), ButterflyScrollRenderer::new);
        List<RegistryObject<EntityType<ButterflyScroll>>> scrolls = this.entityTypeRegistry.getButterflyScrolls();
        for (RegistryObject<EntityType<ButterflyScroll>> registryObject : scrolls) {
            event.registerEntityRenderer((EntityType)registryObject.get(), ButterflyScrollRenderer::new);
        }
        for (RegistryObject registryObject : this.entityTypeRegistry.getCaterpillars()) {
            event.registerEntityRenderer((EntityType)registryObject.get(), CaterpillarRenderer::new);
        }
        for (RegistryObject registryObject : this.entityTypeRegistry.getChrysalises()) {
            event.registerEntityRenderer((EntityType)registryObject.get(), ChrysalisRenderer::new);
        }
    }

    @NotNull
    private static EntityRendererProvider<Butterfly> getButterflyEntityRendererProvider(int butterflyIndex) {
        EntityRendererProvider rendererProvider = ButterflyRenderer::new;
        List<ButterflyData.Trait> traits = Arrays.asList(ButterflyInfo.TRAITS[butterflyIndex]);
        if (traits.contains((Object)ButterflyData.Trait.GLOW)) {
            rendererProvider = GlowButterflyRenderer::new;
        } else if (traits.contains((Object)ButterflyData.Trait.HUMMINGBIRD)) {
            rendererProvider = HummingbirdMothRenderer::new;
        }
        return rendererProvider;
    }
}

