/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.gui.screens;

import com.bokmcdok.butterflies.client.texture.ButterflyTextures;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ButterflyBookScreen
extends Screen {
    private List<FormattedCharSequence> cachedPageComponents = Collections.emptyList();
    private Component pageMsg = TextComponent.f_131282_;
    private PageButton backButton;
    private PageButton forwardButton;
    private final BookAccess bookAccess;
    private int cachedPage = -1;
    private int currentPage;
    private final boolean playTurnSound;

    public ButterflyBookScreen(ItemStack stack) {
        this(new BookAccess(stack), true);
    }

    @Nullable
    public Style getClickedComponentStyleAt(double x, double y) {
        if (this.cachedPageComponents.isEmpty() || this.f_96541_ == null) {
            return null;
        }
        int i = Mth.m_14107_((double)(x - (double)((this.f_96543_ - 192) / 2) - 36.0));
        int j = Mth.m_14107_((double)(y - 2.0 - 30.0));
        if (i >= 0 && j >= 0) {
            int k = Math.min(14, this.cachedPageComponents.size());
            if (i <= 114 && j < 9 * k + k) {
                int l = j / 9;
                if (l < this.cachedPageComponents.size()) {
                    FormattedCharSequence formattedCharSequence = this.cachedPageComponents.get(l);
                    return this.f_96541_.f_91062_.m_92865_().m_92338_(formattedCharSequence, i);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public boolean m_5561_(Style style) {
        if (style != null) {
            ClickEvent clickEvent = style.m_131182_();
            if (clickEvent == null) {
                return false;
            }
            if (clickEvent.m_130622_() == ClickEvent.Action.CHANGE_PAGE) {
                String clickEventValue = clickEvent.m_130623_();
                try {
                    int page = Integer.parseInt(clickEventValue) - 1;
                    return this.forcePage(page);
                }
                catch (Exception exception) {
                    return false;
                }
            }
            boolean flag = super.m_5561_(style);
            if (flag && clickEvent.m_130622_() == ClickEvent.Action.RUN_COMMAND) {
                this.closeScreen();
            }
            return flag;
        }
        return false;
    }

    public boolean m_7933_(int key, int mod1, int mod2) {
        if (super.m_7933_(key, mod1, mod2)) {
            return true;
        }
        return switch (key) {
            case 266 -> {
                this.backButton.m_5691_();
                yield true;
            }
            case 267 -> {
                this.forwardButton.m_5691_();
                yield true;
            }
            default -> false;
        };
    }

    public boolean m_6375_(double x, double y, int button) {
        Style style;
        if (button == 0 && (style = this.getClickedComponentStyleAt(x, y)) != null && this.m_5561_(style)) {
            return true;
        }
        return super.m_6375_(x, y, button);
    }

    public void m_6305_(@NotNull PoseStack poseStack, int x, int y, float unknown) {
        this.m_7333_(poseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ButterflyTextures.BOOK);
        int i = (this.f_96543_ - 192) / 2;
        this.m_93228_(poseStack, i, 2, 0, 0, 192, 192);
        if (this.cachedPage != this.currentPage) {
            FormattedText formattedText = this.bookAccess.getPage(this.currentPage);
            this.cachedPageComponents = this.f_96547_.m_92923_(formattedText, 114);
            this.pageMsg = new TranslatableComponent("book.pageIndicator", new Object[]{this.currentPage + 1, Math.max(this.getNumPages(), 1)});
        }
        this.cachedPage = this.currentPage;
        if (this.cachedPage % 2 == 0) {
            int butterflyIndex = this.bookAccess.getButterflyIndex(this.cachedPage);
            ButterflyData data = ButterflyData.getEntry(butterflyIndex);
            if (data != null) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)data.getScrollTexture());
                this.m_93228_(poseStack, i, 2, 0, 0, 192, 192);
            }
        } else {
            int cachedPageSize = Math.min(14, this.cachedPageComponents.size());
            for (int line = 0; line < cachedPageSize; ++line) {
                FormattedCharSequence formattedCharSequence = this.cachedPageComponents.get(line);
                this.f_96547_.m_92877_(poseStack, formattedCharSequence, (float)i + 36.0f, (float)(32 + line * 9), 0);
            }
        }
        int fontWidth = this.f_96547_.m_92852_((FormattedText)this.pageMsg);
        this.f_96547_.m_92889_(poseStack, this.pageMsg, (float)i - (float)fontWidth + 192.0f - 44.0f, 18.0f, 0);
        Style style = this.getClickedComponentStyleAt(x, y);
        if (style != null) {
            this.m_96570_(poseStack, style, x, y);
        }
        super.m_6305_(poseStack, x, y, unknown);
    }

    public boolean setPage(int page) {
        int i = Mth.m_14045_((int)page, (int)0, (int)(this.bookAccess.getPageCount() - 1));
        if (i != this.currentPage) {
            this.currentPage = i;
            this.updateButtonVisibility();
            this.cachedPage = -1;
            return true;
        }
        return false;
    }

    protected void closeScreen() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(null);
        }
    }

    protected void createMenuControls() {
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, 196, 200, 20, CommonComponents.f_130655_, p_98299_ -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(null);
            }
        }));
    }

    protected void createPageControlButtons() {
        int i = (this.f_96543_ - 192) / 2;
        this.forwardButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(i + 116, 159, true, button -> this.pageForward(), this.playTurnSound));
        this.backButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(i + 43, 159, false, button -> this.pageBack(), this.playTurnSound));
        this.updateButtonVisibility();
    }

    protected boolean forcePage(int page) {
        return this.setPage(page);
    }

    protected void m_7856_() {
        this.createMenuControls();
        this.createPageControlButtons();
    }

    protected void pageBack() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        this.updateButtonVisibility();
    }

    protected void pageForward() {
        if (this.currentPage < this.getNumPages() - 1) {
            ++this.currentPage;
        }
        this.updateButtonVisibility();
    }

    private ButterflyBookScreen(BookAccess access, boolean playTurnSound) {
        super(NarratorChatListener.f_93310_);
        this.bookAccess = access;
        this.playTurnSound = playTurnSound;
    }

    private int getNumPages() {
        return this.bookAccess.getPageCount();
    }

    private void updateButtonVisibility() {
        this.forwardButton.f_93624_ = this.currentPage < this.getNumPages() - 1;
        this.backButton.f_93624_ = this.currentPage > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class BookAccess {
        private ListTag pages;

        public BookAccess(ItemStack stack) {
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                this.pages = tag.m_128437_("pages", 3);
            }
        }

        public int getButterflyIndex(int page) {
            if (this.pages != null) {
                return this.pages.m_128763_(page / 2);
            }
            return 0;
        }

        public FormattedText getPage(int page) {
            return page >= 0 && page < this.getPageCount() ? this.getPageRaw(page) : FormattedText.f_130760_;
        }

        public int getPageCount() {
            if (this.pages != null) {
                return this.pages.size() * 2;
            }
            return 0;
        }

        public FormattedText getPageRaw(int page) {
            if (this.pages != null) {
                int butterflyIndex = this.pages.m_128763_((page - 1) / 2);
                return ButterflyData.getFormattedButterflyData(butterflyIndex);
            }
            return null;
        }
    }
}

