/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.renderer.entity;

import com.bokmcdok.butterflies.client.renderer.entity.EntityDebugInfoRenderer;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public abstract class ButterflyBaseRenderer<T extends Butterfly, M extends EntityModel<T>>
extends MobRenderer<T, M> {
    public ButterflyBaseRenderer(EntityRendererProvider.Context context, M entityModel, float shadowRadius) {
        super(context, entityModel, shadowRadius);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T entity) {
        return ((Butterfly)entity).getTexture();
    }

    protected void renderDebugInfo(@NotNull T entity, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLightCoordinates) {
        EntityDebugInfoRenderer.renderDebugInfo(entity, poseStack, multiBufferSource, this.f_114476_.m_114470_(), this.m_114481_(), packedLightCoordinates);
    }

    protected void rotateIfLanded(@NotNull T entity, @NotNull PoseStack poseStack) {
        if (((Butterfly)entity).getIsLanded()) {
            switch (((Butterfly)entity).getLandedDirection()) {
                case UP: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                    break;
                }
                case NORTH: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                    break;
                }
                case SOUTH: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                    break;
                }
                case EAST: {
                    poseStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
                    break;
                }
                case WEST: {
                    poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-90.0f));
                    break;
                }
            }
        }
    }

    protected void scale(@NotNull Butterfly entity, PoseStack poses, float scale) {
        float s = entity.getRenderScale();
        poses.m_85841_(s, s, s);
    }
}

