/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.event.world.level;

import com.bokmcdok.butterflies.registries.EntityTypeRegistry;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.ButterflyEgg;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import com.bokmcdok.butterflies.world.entity.animal.Chrysalis;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.RegistryObject;

public class LevelEventListener {
    private final EntityTypeRegistry entityTypeRegistry;

    public LevelEventListener(IEventBus forgeEventBus, EntityTypeRegistry entityTypeRegistry) {
        forgeEventBus.register((Object)this);
        forgeEventBus.addListener(this::onBiomeLoading);
        this.entityTypeRegistry = entityTypeRegistry;
    }

    private void onBiomeLoading(BiomeLoadingEvent event) {
        List<RegistryObject<EntityType<ButterflyEgg>>> butterflyEggs = this.entityTypeRegistry.getButterflyEggs();
        List<RegistryObject<EntityType<Caterpillar>>> caterpillars = this.entityTypeRegistry.getCaterpillars();
        List<RegistryObject<EntityType<Chrysalis>>> chrysalises = this.entityTypeRegistry.getChrysalises();
        List<RegistryObject<EntityType<? extends Butterfly>>> butterflies = this.entityTypeRegistry.getButterflies();
        for (int i = 0; i < butterflies.size(); ++i) {
            int weight = 12;
            int maximum = 4;
            if (ButterflyInfo.RARITIES[i] == ButterflyData.Rarity.UNCOMMON) {
                weight = 8;
                maximum = 3;
            } else if (ButterflyInfo.RARITIES[i] == ButterflyData.Rarity.RARE) {
                weight = 4;
                maximum = 2;
            }
            block13: for (ButterflyData.Habitat habitat : ButterflyInfo.HABITATS[i]) {
                switch (habitat) {
                    case FORESTS: {
                        if (!event.getCategory().equals((Object)Biome.BiomeCategory.FOREST)) continue block13;
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)butterflyEggs.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)caterpillars.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)chrysalises.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)butterflies.get(i).get(), weight, 1, maximum));
                        continue block13;
                    }
                    case ICE: {
                        if (!event.getCategory().equals((Object)Biome.BiomeCategory.ICY)) continue block13;
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)butterflies.get(i).get(), weight, 1, maximum));
                        continue block13;
                    }
                    case JUNGLES: {
                        if (!event.getCategory().equals((Object)Biome.BiomeCategory.JUNGLE)) continue block13;
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)butterflyEggs.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)caterpillars.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)chrysalises.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)butterflies.get(i).get(), weight, 1, maximum));
                        continue block13;
                    }
                    case PLAINS: {
                        if (!event.getCategory().equals((Object)Biome.BiomeCategory.PLAINS)) continue block13;
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)butterflyEggs.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)caterpillars.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)chrysalises.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)butterflies.get(i).get(), weight, 1, maximum));
                        continue block13;
                    }
                    case NETHER: {
                        if (!event.getCategory().equals((Object)Biome.BiomeCategory.NETHER)) continue block13;
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)butterflies.get(i).get(), weight, 1, maximum));
                        continue block13;
                    }
                    case VILLAGES: {
                        if (!event.getCategory().equals((Object)Biome.BiomeCategory.PLAINS) && !event.getCategory().equals((Object)Biome.BiomeCategory.DESERT) && !event.getCategory().equals((Object)Biome.BiomeCategory.FOREST) && !event.getCategory().equals((Object)Biome.BiomeCategory.SAVANNA)) continue block13;
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)butterflyEggs.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)caterpillars.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)chrysalises.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)butterflies.get(i).get(), weight, 1, maximum));
                        continue block13;
                    }
                    case HILLS: {
                        if (!event.getCategory().equals((Object)Biome.BiomeCategory.EXTREME_HILLS) && !event.getCategory().equals((Object)Biome.BiomeCategory.MOUNTAIN)) continue block13;
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)butterflyEggs.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)caterpillars.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)chrysalises.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)butterflies.get(i).get(), weight, 1, maximum));
                        continue block13;
                    }
                    case PLATEAUS: {
                        if (!event.getCategory().equals((Object)Biome.BiomeCategory.MESA)) continue block13;
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)butterflyEggs.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)caterpillars.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)chrysalises.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)butterflies.get(i).get(), weight, 1, maximum));
                        continue block13;
                    }
                    case SAVANNAS: {
                        if (!event.getCategory().equals((Object)Biome.BiomeCategory.SAVANNA)) continue block13;
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)butterflyEggs.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)caterpillars.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)chrysalises.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)butterflies.get(i).get(), weight, 1, maximum));
                        continue block13;
                    }
                    case WETLANDS: {
                        if (!event.getCategory().equals((Object)Biome.BiomeCategory.SWAMP) && !event.getCategory().equals((Object)Biome.BiomeCategory.RIVER)) continue block13;
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)butterflyEggs.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)caterpillars.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)chrysalises.get(i).get(), weight, 1, maximum));
                        event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)butterflies.get(i).get(), weight, 1, maximum));
                        continue block13;
                    }
                }
            }
        }
    }
}

