/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.registries.BlockEntityTypeRegistry;
import com.bokmcdok.butterflies.registries.ItemRegistry;
import com.bokmcdok.butterflies.registries.MenuTypeRegistry;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.block.BottledButterflyBlock;
import com.bokmcdok.butterflies.world.block.BottledCaterpillarBlock;
import com.bokmcdok.butterflies.world.block.ButterflyFeederBlock;
import com.bokmcdok.butterflies.world.block.ButterflyMicroscopeBlock;
import com.bokmcdok.butterflies.world.block.ButterflyOrigamiBlock;
import com.bokmcdok.butterflies.world.block.FlowerCropBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class BlockRegistry {
    private static final String[] ORIGAMI_IDS = new String[]{"butterfly_origami_black", "butterfly_origami_blue", "butterfly_origami_brown", "butterfly_origami_cyan", "butterfly_origami_gray", "butterfly_origami_green", "butterfly_origami_light_blue", "butterfly_origami_light_gray", "butterfly_origami_lime", "butterfly_origami_magenta", "butterfly_origami_orange", "butterfly_origami_pink", "butterfly_origami_purple", "butterfly_origami_red", "butterfly_origami_white", "butterfly_origami_yellow"};
    private static final BlockBehaviour.Properties BOTTLED_BUTTERFLY_PROPERTIES = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60924_(BlockRegistry::never).m_60960_(BlockRegistry::never).m_60922_(BlockRegistry::never).m_60971_(BlockRegistry::never).m_60955_().m_60918_(SoundType.f_56744_).m_60978_(0.3f);
    private static final BlockBehaviour.Properties GLOWING_BOTTLED_BUTTERFLY_PROPERTIES = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60924_(BlockRegistry::never).m_60960_(BlockRegistry::never).m_60922_(BlockRegistry::never).m_60971_(BlockRegistry::never).m_60955_().m_60918_(SoundType.f_56744_).m_60978_(0.3f).m_60953_(blockstate -> 15);
    private final DeferredRegister<Block> deferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"butterflies");
    private List<RegistryObject<Block>> bottledButterflyBlocks;
    private List<RegistryObject<Block>> bottledCaterpillarBlocks;
    private RegistryObject<Block> butterflyFeeder;
    private RegistryObject<Block> butterflyMicroscope;
    private RegistryObject<Block> alliumBud;
    private RegistryObject<Block> azureBluetBud;
    private RegistryObject<Block> blueOrchidBud;
    private RegistryObject<Block> cornflowerBud;
    private RegistryObject<Block> dandelionBud;
    private RegistryObject<Block> lilyOfTheValleyBud;
    private RegistryObject<Block> orangeTulipBud;
    private RegistryObject<Block> oxeyeDaisyBud;
    private RegistryObject<Block> pinkTulipBud;
    private RegistryObject<Block> poppyBud;
    private RegistryObject<Block> redTulipBud;
    private RegistryObject<Block> whiteTulipBud;
    private RegistryObject<Block> witherRoseBud;
    private List<RegistryObject<Block>> butterflyOrigami;

    public static boolean never(BlockState ignoredBlockState, BlockGetter ignoredBlockGetter, BlockPos ignoredBlockPos, EntityType<?> ignoredEntityType) {
        return false;
    }

    public static boolean never(BlockState ignoredBlockState, BlockGetter ignoredBlockGetter, BlockPos ignoredBlockPos) {
        return false;
    }

    public BlockRegistry(@NotNull IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise(@NotNull BlockEntityTypeRegistry blockEntityTypeRegistry, @NotNull ItemRegistry itemRegistry, @NotNull MenuTypeRegistry menuTypeRegistry) {
        RegistryObject newBlock;
        int i;
        Objects.requireNonNull(blockEntityTypeRegistry);
        Objects.requireNonNull(itemRegistry);
        Objects.requireNonNull(menuTypeRegistry);
        this.bottledButterflyBlocks = new ArrayList<RegistryObject<Block>>();
        for (i = 0; i < ButterflyInfo.SPECIES.length; ++i) {
            newBlock = this.registerBottledButterfly(i);
            this.bottledButterflyBlocks.add(newBlock);
        }
        this.bottledCaterpillarBlocks = new ArrayList<RegistryObject<Block>>();
        for (i = 0; i < ButterflyInfo.SPECIES.length; ++i) {
            newBlock = this.deferredRegister.register(this.getBottledCaterpillarRegistryId(i), BottledCaterpillarBlock::new);
            this.bottledCaterpillarBlocks.add((RegistryObject<Block>)newBlock);
        }
        this.alliumBud = this.deferredRegister.register("bud_allium", () -> new FlowerCropBlock(Blocks.f_50114_));
        this.azureBluetBud = this.deferredRegister.register("bud_azure_bluet", () -> new FlowerCropBlock(Blocks.f_50115_));
        this.blueOrchidBud = this.deferredRegister.register("bud_blue_orchid", () -> new FlowerCropBlock(Blocks.f_50113_));
        this.cornflowerBud = this.deferredRegister.register("bud_cornflower", () -> new FlowerCropBlock(Blocks.f_50121_));
        this.dandelionBud = this.deferredRegister.register("bud_dandelion", () -> new FlowerCropBlock(Blocks.f_50111_));
        this.lilyOfTheValleyBud = this.deferredRegister.register("bud_lily_of_the_valley", () -> new FlowerCropBlock(Blocks.f_50071_));
        this.orangeTulipBud = this.deferredRegister.register("bud_orange_tulip", () -> new FlowerCropBlock(Blocks.f_50117_));
        this.oxeyeDaisyBud = this.deferredRegister.register("bud_oxeye_daisy", () -> new FlowerCropBlock(Blocks.f_50120_));
        this.pinkTulipBud = this.deferredRegister.register("bud_pink_tulip", () -> new FlowerCropBlock(Blocks.f_50119_));
        this.poppyBud = this.deferredRegister.register("bud_poppy", () -> new FlowerCropBlock(Blocks.f_50112_));
        this.redTulipBud = this.deferredRegister.register("bud_red_tulip", () -> new FlowerCropBlock(Blocks.f_50116_));
        this.whiteTulipBud = this.deferredRegister.register("bud_white_tulip", () -> new FlowerCropBlock(Blocks.f_50118_));
        this.witherRoseBud = this.deferredRegister.register("bud_wither_rose", () -> new FlowerCropBlock(Blocks.f_50070_));
        this.butterflyFeeder = this.deferredRegister.register("butterfly_feeder", () -> new ButterflyFeederBlock(blockEntityTypeRegistry, menuTypeRegistry));
        this.butterflyMicroscope = this.deferredRegister.register("butterfly_microscope", () -> new ButterflyMicroscopeBlock(itemRegistry, menuTypeRegistry));
        this.butterflyOrigami = new ArrayList<RegistryObject<Block>>();
        for (String id : ORIGAMI_IDS) {
            this.butterflyOrigami.add(this.registerButterflyOrigami(id));
        }
    }

    public RegistryObject<Block> getAlliumBud() {
        return this.alliumBud;
    }

    public RegistryObject<Block> getAzureBluetBud() {
        return this.azureBluetBud;
    }

    public RegistryObject<Block> getBlueOrchidBud() {
        return this.blueOrchidBud;
    }

    public List<RegistryObject<Block>> getBottledButterflyBlocks() {
        return this.bottledButterflyBlocks;
    }

    public List<RegistryObject<Block>> getBottledCaterpillarBlocks() {
        return this.bottledCaterpillarBlocks;
    }

    public RegistryObject<Block> getButterflyFeeder() {
        return this.butterflyFeeder;
    }

    public RegistryObject<Block> getButterflyMicroscope() {
        return this.butterflyMicroscope;
    }

    public List<RegistryObject<Block>> getButterflyOrigami() {
        return this.butterflyOrigami;
    }

    public RegistryObject<Block> getCornflowerBud() {
        return this.cornflowerBud;
    }

    public RegistryObject<Block> getDandelionBud() {
        return this.dandelionBud;
    }

    public RegistryObject<Block> getLilyOfTheValleyBud() {
        return this.lilyOfTheValleyBud;
    }

    public RegistryObject<Block> getOrangeTulipBud() {
        return this.orangeTulipBud;
    }

    public RegistryObject<Block> getOxeyeDaisyBud() {
        return this.oxeyeDaisyBud;
    }

    public RegistryObject<Block> getPinkTulipBud() {
        return this.pinkTulipBud;
    }

    public RegistryObject<Block> getPoppyBud() {
        return this.poppyBud;
    }

    public RegistryObject<Block> getRedTulipBud() {
        return this.redTulipBud;
    }

    public RegistryObject<Block> getWhiteTulipBud() {
        return this.whiteTulipBud;
    }

    public RegistryObject<Block> getWitherRoseBud() {
        return this.witherRoseBud;
    }

    private String getBottledButterflyRegistryId(int butterflyIndex) {
        return "bottled_butterfly_" + ButterflyInfo.SPECIES[butterflyIndex];
    }

    private String getBottledCaterpillarRegistryId(int butterflyIndex) {
        return "bottled_caterpillar_" + ButterflyInfo.SPECIES[butterflyIndex];
    }

    private RegistryObject<Block> registerBottledButterfly(int butterflyIndex) {
        String registryId = this.getBottledButterflyRegistryId(butterflyIndex);
        if (Arrays.asList(ButterflyInfo.TRAITS[butterflyIndex]).contains((Object)ButterflyData.Trait.GLOW)) {
            return this.deferredRegister.register(registryId, () -> new BottledButterflyBlock(GLOWING_BOTTLED_BUTTERFLY_PROPERTIES));
        }
        return this.deferredRegister.register(registryId, () -> new BottledButterflyBlock(BOTTLED_BUTTERFLY_PROPERTIES));
    }

    private RegistryObject<Block> registerButterflyOrigami(String id) {
        return this.deferredRegister.register(id, ButterflyOrigamiBlock::new);
    }
}

