/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.block;

import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BottledButterflyBlock
extends Block {
    private static final String NAME = "block.butterflies.bottled_butterfly";
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)10.0, (double)1.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)11.0, (double)2.0, (double)11.0), Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)12.0, (double)6.0, (double)12.0), Block.m_49796_((double)4.0, (double)6.0, (double)4.0, (double)11.0, (double)7.0, (double)11.0), Block.m_49796_((double)5.0, (double)7.0, (double)5.0, (double)10.0, (double)8.0, (double)10.0), Block.m_49796_((double)6.0, (double)8.0, (double)6.0, (double)9.0, (double)10.0, (double)9.0), Block.m_49796_((double)5.0, (double)10.0, (double)5.0, (double)10.0, (double)12.0, (double)10.0), Block.m_49796_((double)6.0, (double)12.0, (double)6.0, (double)9.0, (double)13.0, (double)9.0)});

    public BottledButterflyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_6786_(@NotNull LevelAccessor level, @NotNull BlockPos position, @NotNull BlockState state) {
        super.m_6786_(level, position, state);
        this.removeButterfly(level, position, Entity.RemovalReason.DISCARDED);
    }

    @NotNull
    public MutableComponent m_49954_() {
        return new TranslatableComponent(NAME);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos position, @NotNull CollisionContext collisionContext) {
        return SHAPE;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    public void m_6810_(@NotNull BlockState oldBlockState, @NotNull Level level, @NotNull BlockPos position, @NotNull BlockState newBlockState, boolean flag) {
        super.m_6810_(oldBlockState, level, position, newBlockState, flag);
        this.removeButterfly((LevelAccessor)level, position, Entity.RemovalReason.KILLED);
    }

    private void removeButterfly(LevelAccessor level, BlockPos position, Entity.RemovalReason reason) {
        AABB aabb = new AABB(position);
        List butterflies = level.m_45976_(Butterfly.class, aabb);
        for (Butterfly i : butterflies) {
            i.m_142687_(reason);
        }
    }
}

